<?php
/*
 * \SentraDesigner\fills\Form\render.scripts\form.class.functions.php
 *
 * Generic HTML5 form class, used in designs made by VTD
 *
 */
If (defined ('SENTRA_DESIGNER')) {
	/* Here the class is activated in VTD */
	If (!isset($FormGriddy)) {
		$TotalWidth = 10;
		$LeftWidth 	= $myCMD['Data']['Ratio']/$TotalWidth;
		$RightWidth = $TotalWidth - $myCMD['Data']['Ratio']/$TotalWidth;

		$FormGriddy = new FormGriddy(array($LeftWidth,$RightWidth),$TotalWidth);
	}
} Else {
	/* Here we are on the target server (=online) or in SENTRA's preview mode */
	If (defined('I_am_Online')) {
		/* Here we are on the target server (=online) */
		defined ('SENTRA_START_TIME') or die (__FILE__.':::Sentra message: Illegal direct call');
		require_once(SENTRA_SCRIPT_HOME.'formgriddy.class.php');

	} Else {
		/* Here we are in SENTRA preview mode */
		If (file_exists(DESIGNRENDERSCRIPTS.'formgriddy.class.php')) {
			require_once(DESIGNRENDERSCRIPTS.'formgriddy.class.php');

		} Else {
			require_once('./phpscripts/formgriddy.class.php');
		}
	}
	$FormGriddy = new FormGriddy(array($LeftWidth,$RightWidth),$TotalWidth);
}

class vtdHTML5form {
	private $TICKET='';
	private $WarningText='';
	private $formXMLdata;
	public  $formpara = array();
	private $lurevalue;
	public	$RenderedForm='';
	public	$FieldSets='';
	private $TabIndex=0;
	private $FormGriddy;/* Griddy-class */
	public function __construct($formXMLdata,$formpara, $FormGriddy) {
		$this -> TabIndex 		= 0;
		$this -> WarningText	= '';
		$this -> FormGriddy		= $FormGriddy;
		$this -> formXMLdata	= $formXMLdata;
		$this -> formpara			= $formpara;
		If (defined ('SENTRA_DESIGNER')) {
			require_once (CAPTCHA.'captcha-class.php');
			$GLOBALS['FormError']['emailformat'] = 'Ungültiges eMail-Format';

		} Else if (file_exists(SENTRA_HOME.'assets/_captcha/captcha-class.php')) {
			require_once (SENTRA_HOME.'assets/_captcha/captcha-class.php');

		} Else {
			if (file_exists('../../../defaults/script_archive/captcha/captcha-class.php')) {
				/* Here: SENTRA preview is active */
				require_once ('../../../defaults/script_archive/captcha/captcha-class.php');
			}
		}
	}

/*
JQuery validation messages:
messages: {
  required: "This field is required.",
  remote: "Please fix this field.",
  email: "Please enter a valid email address.",
  url: "Please enter a valid URL.",
  date: "Please enter a valid date.",
  dateISO: "Please enter a valid date ( ISO ).",
  number: "Please enter a valid number.",
  digits: "Please enter only digits.",
  creditcard: "Please enter a valid credit card number.",
  equalTo: "Please enter the same value again.",
  maxlength: $.validator.format( "Please enter no more than {0} characters." ),
  minlength: $.validator.format( "Please enter at least {0} characters." ),
  rangelength: $.validator.format( "Please enter a value between {0} and {1} characters long." ),
  range: $.validator.format( "Please enter a value between {0} and {1}." ),
  max: $.validator.format( "Please enter a value less than or equal to {0}." ),
  min: $.validator.format( "Please enter a value greater than or equal to {0}." )
 },
*/
	public function GriddyRenderCountryselect($label,
																						$name,
																						$input_param,
																						$user_input,
																						$inpcomment,                      		/* 'Zusatztext' 						*/
																						$warningclass) {

		$SelectBox = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$SelectBox = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}

		$countries = $this -> form_get_countries();
		$size=1;
		If (isset($input_param['required']) &&
				isset($input_param['required'][0]) &&
				isset($input_param['required'][0]['value'])) {
			$closetag = PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'" required>'.PHP_EOL;
		} Else {
			$closetag = '>'.PHP_EOL;
		}
		If (isset($input_param['size']) &&
				isset($input_param['size'][0]) &&
				isset($input_param['size'][0]['value']) &&
				$input_param['size'][0]['value'] > 150)  $size=$input_param['size'][0]['value'];
		$RightContent = '<select id="'.$name.'_'.$this -> formpara['FORMsID'].'" name="'.$name.'"'.$warningclass.' size="'.$size.'"'.$closetag;
		/* See if we have to append some options in front of the country lists:*/
		for ($i=0;$i < count($input_param['uservalue']); $i++) {
			If (isset($input_param['uservalue']) &&
					isset($input_param['uservalue'][$i]) &&
					isset($input_param['uservalue'][$i]['value'])) {
				If (isset($input_param['required']) &&
						isset($input_param['required'][0]) &&
						isset($input_param['required'][0]['value']) &&
						$input_param['uservalue'][$i]['value'] == $input_param['required'][0]['value']) {
					If ($i > 0) {
						$RightContent .= '<option selected="selected" value="USERVALUE-!_'.$i.'">'.$input_param['uservalue'][$i]['value'].'</option>';
					} Else {
						$RightContent .= '<option selected="selected" value="">'.$input_param['uservalue'][$i]['value'].'</option>';
					}
				} Else {
					If ($i > 0) {
						$RightContent .= '<option value="USERVALUE-!_'.$i.'">'.$input_param['uservalue'][$i]['value'].'</option>';
					} Else {
						$RightContent .= '<option value="">'.$input_param['uservalue'][$i]['value'].'</option>';
					}
				}
			}
		}
		/* Now process all countries out of the region list:*/
		for($i=0; $i < count($input_param['region']); $i++) {	/* Loop over all defined global regions*/
			$RightContent .= '<optgroup label="'.$input_param['region'][$i]['value'].'">'.PHP_EOL;
			foreach($countries[$input_param['region'][$i]['value']] as $key => $value) {
				$selected = '';
				If (isset($input_param['selected']) &&
						isset($input_param['selected'][0]) &&
						isset($input_param['selected'][0]['value']) &&
				$input_param['selected'][0]['value']==$value) $selected = ' selected="selected"';
				/*Did visitor already enter a selection? If so overwrite the selected attribute*/
				If (isset($user_input[$name]['selected']) &&
						isset($user_input[$name]['selected'][0]) &&
						isset($user_input[$name]['selected'][0]['value']) &&
						$user_input[$name]['selected'][0]['value']) {
					$selected = '';
					If ($value == $user_input[$name]['value']) {
					 $selected = ' selected="selected"';
					}
				}
				$RightContent .= '<option value="'.$input_param['region'][$i]['value']."-!_".$key.'"'.$selected.'>'.$value.'</option>'.PHP_EOL;
			}
			$RightContent .= '</optgroup>';
		}
		$RightContent .= '</select>'.PHP_EOL;
		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}

		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);


		$SelectBox .= $this -> FormGriddy -> GetHtml();
		return  $SelectBox;

	}
	public function GriddyRenderRadios ($label,    		/* $label, 												*/
																			$FORMsID,			/* $this -> formpara['FORMsID']   */
																			$RadioMode,		/* = "standard" or "fancy"				*/
																			$name,				/* server variable								*/
																			$input_param,
																			$options,   	/* $input_param['option'],				*/
																			$user_input,	/* $user_input[$name]['option'], 	*/
																			$inpcomment,	/* 'Zusatztext'										*/
																			$requiredstr){/* 'required="required"' or ''		*/


		global $GETPOSTvars;
		$RadioBox = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$RadioBox = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}


		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,$label,TRUE);
		}
		$RightContent = '	<div class="flexcol">';
		for ($k=0; $k < count($options); $k++) {
			$checked = '';
			If (isset($GETPOSTvars) && isset($GETPOSTvars[$name])) {
				If (isset($user_input[$k]) &&
						isset($user_input[$k]['radiocheck']) &&
						isset($user_input[$k]['radiocheck'][0]) &&
									$user_input[$k]['radiocheck'][0]['value'] == 'True') $checked = ' checked="checked"';
			} Else {
				If ($options[$k]['radiocheck'][0]['value'] == 'True') $checked = ' checked="checked"';
			}
			If ($RadioMode == 'fancy') {
				$RightContent .=
				'<p class="fancy">'.PHP_EOL.
				'	<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$FORMsID.'"'.
				' type="radio"'.$checked.
				' name="'.$name.'"'.
				' value="'.FrmData::PrepareValue ($options[$k]['radiovalue'][0]['value']).'"';
				If (isset($input_param['required']) &&
						isset($input_param['required'][0]['value'])) {
					$RightContent .= ' '.$requiredstr.PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
				} Else {
					$RightContent .= '>'.PHP_EOL;
				}
				$RightContent .=
				'	<label for="'.$name.$k.'_'.$FORMsID.'">'.PHP_EOL.
				' 	'.FrmData::PrepareValue ($options[$k]['radiolabel'][0]['value']).PHP_EOL.
				'	</label>'.PHP_EOL.
				'</p>		<!-- Close  class="fancy" -->'.PHP_EOL;
			} Else {

				$RightContent .=
				'<p class="standard">'.PHP_EOL.
				'	<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$FORMsID.'"'.
				' type="radio" '.$checked.
				'name="'.$name.'" '.
				' value="'.FrmData::PrepareValue ($options[$k]['radiovalue'][0]['value']).'" '.$requiredstr;
				If (isset($input_param['required']) &&
						isset($input_param['required'][0]['value'])) {
					$RightContent .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
				} Else {
					$RightContent .= '>'.PHP_EOL;
				}
				$RightContent .=
				'	<label for="'.$name.$k.'_'.$FORMsID.'">'.PHP_EOL.
				' 	'.FrmData::PrepareValue ($options[$k]['radiolabel'][0]['value']).PHP_EOL.
				'	</label>'.PHP_EOL.
				'</p>		<!-- Close  class="standard" -->'.PHP_EOL;
			}
		}
		$RightContent .= '	</div> <!-- Close class="flexcol" -->';
		$this -> TabIndex++;
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
		$RadioBox .= $this -> FormGriddy -> GetHtml();
		return  $RadioBox;

}
	public function GriddyRenderSelectBox($label,					/* label 										*/
																				$warningclass,  /* 'class="warning"' or ''	*/
																				$FORMsID,				/* ID 											*/
																				$name,          /* server variable					*/
																				$input_param,
																				$user_input,
																				$optgroup,      /* selectbox optionsgroup 	*/
																				$inpcomment,    /* 'Zusatztext' 						*/
																				$requiredstr) { /* 'required' or ''					*/

		$SelectBox = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$SelectBox = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';


		}

		$retval = '<select id="'.$name.'_'.$FORMsID.'" name="'.$name.'" '.$warningclass;
		If (isset($input_param['required']) &&
				isset($input_param['required'][0]) &&
				isset($input_param['required'][0]['value'])) {
			$retval .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'" required>'.PHP_EOL;
		} Else {
			$retval .= '">'.PHP_EOL;
		}
		for ($og=0; $og < count($optgroup); $og++) {
			If (isset($optgroup[$og]) &&
					isset($optgroup[$og]['label']) &&
					isset($optgroup[$og]['label'][0]) &&
					isset($optgroup[$og]['label'][0]['value']) &&
					trim ($optgroup[$og]['label'][0]['value']) != "") {
				$retval .= '<optgroup label="'.FrmData::PrepareValue ($optgroup[$og]['label'][0]['value']).'">'.PHP_EOL;
			}
			If (!isset($optgroup[$og]['option'])) {
				$optCount = -1;
			} Else {
				$optCount = count($optgroup[$og]['option']);
			}
			for ($k=0; $k < $optCount; $k++) {
				$selected = '';
				If (isset($optgroup[$og]['option'][$k]) &&
						isset($optgroup[$og]['option'][$k]['selected'])) $selected = ' selected ';
				If (isset($optgroup[$og]['option']) &&
						isset($optgroup[$og]['option'][$k]) &&
						isset($optgroup[$og]['option'][$k]['selected']))  {
					$selected = '';
					If (isset($optgroup[$og]['option']) &&
							isset($optgroup[$og]['option'][$k]) &&
							$optgroup[$og]['option'][$k]['selected']) $selected = ' selected ';
				}
				If ($og == 0 &&
						$k  == 0 &&
						isset($user_input['optgroup'][$og]) &&
						isset($user_input['optgroup'][$og]['option'][$k]) &&
						isset($user_input['optgroup'][$og]['option'][$k]['selected']) &&
						!$user_input['optgroup'][$og]['option'][$k]['selected']) {

							$selected = ' selected="selected" ';
						} ElseIf (isset($user_input['optgroup'][$og]) &&
											isset($user_input['optgroup'][$og]['option'][$k]) &&
											isset($user_input['optgroup'][$og]['option'][$k]['selected'])) {
							$selected = ' selected="selected" ';
						}

				If ($k > 0) {
					$retval .= '<option value="'.$og."-!_".$k.'"'.$selected.'>'.PHP_EOL;
				} Else {
					$retval .= '<option value=""'.$selected.'>'.PHP_EOL;
				}
				$retval		.= ' '.FrmData::PrepareValue ($optgroup[$og]['option'][$k]['optionlabel'][0]['value']).PHP_EOL.
										 '</option>'.PHP_EOL;;
			}
			If (isset($optgroup) &&
					isset($optgroup[$og]) &&
					isset($optgroup[$og]['label']) &&
					isset($optgroup[$og]['label'][0]) &&
					isset($optgroup[$og]['label'][0]['value']) &&
					trim($optgroup[$og]['label'][0]['value']) != "") {
				$retval .= '</optgroup>';
			}
		}
		$retval.= '</select>'.PHP_EOL;
		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}
		$this -> FormGriddy -> AddtoXY(1,0,$retval,TRUE);

		$this -> TabIndex++;

		$SelectBox .= $this -> FormGriddy -> GetHtml();
		return $SelectBox;
	}

	public function GriddyRenderS_CheckBox ($label,				/* label										*/
																					$warningitem, /* 'warning' or ''					*/
																					$FORMsID,     /* ID 											*/
																					$CheckMode,		/* =="standard" or "fancy"  */
																					$name,        /* server variable					*/
																					$input_param,
																					$optionsvalue,/* checkbox value 					*/
																					$inpcomment,  /* 'Zusatztext' 						*/
																					$requiredstr, /* 'required' or ''					*/
																					$checked) {   /* ' checked="checked"'or ''*/
		$S_CheckBox = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);

			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$S_CheckBox = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}
		If ($CheckMode == 'fancy') {
			$pclass="fancy";

		} Else {
			$pclass="standard";
		}
		$RightContent = '<p class="'.$pclass.'">'.PHP_EOL.
			              '	<input tabindex="'.$this -> TabIndex.'"  id="'.$name.'_'.$FORMsID.'" type="checkbox"'.$checked.
			              ' name="'.$name.'" value="'.base64_encode($optionsvalue).'" '.$requiredstr;
		If (isset($input_param['required']) && isset($input_param['required'][0]['value'])) {
			$RightContent .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
		} Else {
			$RightContent .= '>'.PHP_EOL;
		}
		If (trim($warningitem) != '') {
			$RightContent .=
				'	<label class="'.trim($warningitem).'" for="'.$name.'_'.$FORMsID.'">'.PHP_EOL.
				'	'.$optionsvalue.PHP_EOL.
				'	</label>'.PHP_EOL;
		} Else {
			$RightContent .= '	<label for="'.$name.'_'.$FORMsID.'">'.PHP_EOL.
				               '	'.$optionsvalue.PHP_EOL.
				               '	</label>'.PHP_EOL;
		}
		$RightContent .=
			'</p>	<!-- Close class="'.$pclass.'" -->'.PHP_EOL;

		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}

		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);

		$this -> TabIndex++;
		$S_CheckBox .= $this -> FormGriddy -> GetHtml();
		return $S_CheckBox;

}
	public function GriddyRenderComment($label,
																			$comment,$cmt = true) {
		if ($cmt)
			$RightContent = '<div class="inpcomment">'.PHP_EOL. $comment.PHP_EOL.'</div><!-- close  class="inpcomment" -->'.PHP_EOL;
		else
			$RightContent = '<div>'.PHP_EOL. $comment.PHP_EOL.'</div><!-- close  class="inpcomment" -->'.PHP_EOL;

		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
		$this -> TabIndex++;
		return $this -> FormGriddy -> GetHtml();
	}

	public function GriddyRenderInputTEXT($label,						/* $label                                  */
																				$warningclass,    /*  $warningclass,                         */
																				$type,            /*  $input_param['type'][0]['value'],      */
																				$FORMsID,         /* - $this -> formpara['FORMsID'],         */
																				$name,            /*  $name,$this -> formpara['FORMsID'],    */
																				$input_param,
																				$value,           /*  FrmData::PrepareValue ($value),        */
																				$inpcomment,			/*  equals "Zusatztext"										 */
																				$requiredstr) {   /*  $requiredstr);                         */
		$TextInput = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$TextInput = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}
		$placeholder = '';
		If ($this -> formpara['LabelPosition'] == 'placeholder') {
			$placeholder = ' placeholder="'.$label.'"';
			$label = '';
		}
		$MaxLength = '';
		If ($input_param['maxlength'][0]['value'] > 0) {
			$MaxLength = 'maxlength="'.$input_param['maxlength'][0]['value'].'"';
		}
		$RightContent = '<div class="input-effect">'.PHP_EOL.
										'	<input tabindex="'.$this -> TabIndex.'" '.$warningclass.
										' type="'.$type.'"'.
										' id="'.$name.'_'.$FORMsID.'"'.
										' name="'.$name.'"'.
										' value="'.$value.'"'.
										$placeholder.
										' '.$requiredstr.
										'	'.$MaxLength;

		SWITCH($type) {
			case 'text':
#				$RightContent .= PHP_EOL.' data-rule-minlength="2"';
				$RightContent .= PHP_EOL.' data-msg="Füllen Sie bitte das '.$label.'-Feld aus"';
			break;
			case 'email':
#				$RightContent .= PHP_EOL.' data-rule-minlength="5"';
				$RightContent .= PHP_EOL.' data-msg-email="'.$GLOBALS['FormError']['emailformat'].'"';
			break;
			case 'password':
#				$RightContent .= PHP_EOL.' data-rule-minlength="16"';
			break;
		}
		If (isset($input_param['required']) && isset($input_param['required'][0]['value'])) {
			$RightContent .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
		} Else {
			$RightContent .= '>'.PHP_EOL;
		}
		$RightContent 	.='</div>	<!-- Close class="input-effect" -->'.PHP_EOL.
											'<div class="ready hidden"></div>';
		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}

		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);

		If (trim($requiredstr) != '') {
			$this -> FormGriddy -> DecoClass[1] = 'required';
		} Else {

		}
		$TextInput .= $this -> FormGriddy -> GetHtml();
		$this -> FormGriddy -> DecoClass[1] = '';

		$this -> TabIndex++;
		return $TextInput;
	}
	public function GriddyRenderTextArea($label,
																				$warningclass,
																				$ID,
																				$rows,
																				$name,
																				$input_param,
																				$inpcomment,
																				$readonly,
																				$requiredstr,
																				$value)	{					/* content */
		$TextareaInput = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$TextareaInput = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}
		$placeholder = '';
		If ($this -> formpara['LabelPosition'] == 'placeholder') {
			$placeholder = ' placeholder="'.$label.'"';
			$label = '';
		} ElseIf ($this -> formpara['LabelPosition'] == 'top') {

		} ElseIf ($this -> formpara['LabelPosition'] == 'left') {
			$label = '<p class="textarealb">'.$label.'</p>';
		}
		$RightContent = '<div class="input-effect">'.PHP_EOL.
										'	<textarea '.$warningclass.
										' tabindex="'.$this -> TabIndex.'" '.PHP_EOL.
										' id="'.$ID.'"'.
										' rows="'.$rows.'" '.
										' name="'.$name.'"'.
										$placeholder;
		If (isset($readonly) && trim($readonly)!='')
		$RightContent.= PHP_EOL.' '.$readonly;
		If (isset($requiredstr) && trim($requiredstr)!='')
			$RightContent.= PHP_EOL.' '.$requiredstr;
#		$RightContent.= PHP_EOL.' data-rule-minlength="8"'.PHP_EOL;
		If (isset($input_param['required']) && isset($input_param['required'][0]['value'])) {
			$RightContent .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
		} Else {
			$RightContent .= '>'.PHP_EOL;
		}
		$RightContent.= $value.'</textarea>'.PHP_EOL.
										'</div>	<!-- Close class="input-effect" -->'.PHP_EOL.
										'<div class="ready hidden"></div>';
		$this -> FormGriddy -> AddtoXY(0,0,$label      ,TRUE);
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
		$TextareaInput .= $this -> FormGriddy -> GetHtml();
		$this -> TabIndex++;
		return $TextareaInput;
	}

	public function GriddyRenderSendBtn($label,			     		/* $label           								*/
																			$buttontext,
																			$buttonaligned,   	/* button alignment 								*/
																			$name,            	/* $input_param['name'][0]['value'] */
																			$btnStyle,					/* button styling										*/
																			$btnSize) {					/* ButtonSize												*/
		$classbuttonalign = ' btn-left';
		SWITCH ($buttonaligned) {
			case 'left':
				$classbuttonalign = ' btn-left';
			break;

			case 'center':
				$classbuttonalign = ' icenter';
			break;

			case 'w100':
				$classbuttonalign = ' btn-w100';
			break;

			default:
			case 'right':
				$classbuttonalign = ' btn-right';
			break;
		}

		$disabled = '';
		$RightContent = '<input type="hidden" name="action" value="submit"'.">".PHP_EOL.
										'<input type="hidden" name="'.$name.'" value="'.$name.'"'.">".PHP_EOL.
										'<button class="'.$btnStyle.$btnSize.$classbuttonalign.'">'.$buttontext.'</button>';
		$this -> FormGriddy -> AddtoXY(0,0,$label      ,TRUE);/* TRUE means, previous content is cleared */
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
		$this -> TabIndex++;
		return $this -> FormGriddy -> GetHtml();
	}
	public function GriddyRenderCaptcha($label,						/* $label 													*/
																			$name,						/* $input_param['name'][0]['value'] */
																			$input_param,
																			$user_input,
																			$inpcomment,      /* 'Zusatztext' 										*/
																			$requiredstr,
																			$warningclass) {	/* $warningclass,   								*/

		$CaptchaBox = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$CaptchaBox = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}
		$CaptMsg = '';
		SWITCH ($this -> formpara['CaptchaMode']) {
			case 0:
			case 1:
			case 2:
			case 3: {/* Grafic captcha */
				/* Generate Captcha image */
				$captcha = new captcha();
				$captcha->imagealt = $input_param['alt'][0]['value'];
				if ($this -> TICKET == '') {
					$ticket = $captcha->newTicket();
				} else {
					$ticket = $this -> TICKET;
				}
				$this -> TICKET = '';
				$CaptchaImg		 = '	<a href="#" onclick="javascript:refreshCAPTCHA('."'".$ticket."'".','.$this -> formpara['CaptchaMode'].','.$this -> formpara['CaptchaDigits'].','."'".$this -> formpara['CaptchaBack']."'".','."'".$this -> formpara['CaptchaFore']."'".'); return false">'.PHP_EOL;
				$CaptchaImg 	.= '		'.$captcha->returnImage($ticket,$this -> formpara['CaptchaMode'],$this -> formpara['CaptchaDigits'],$this -> formpara['CaptchaBack'],$this -> formpara['CaptchaFore']).PHP_EOL;
				$CaptchaImg		.= '	</a>'.PHP_EOL;
				/* Compile "Captcha Message", if one is available (In SENTRA: "Aufforderung neuer Code" */
				$CaptMsg = '';
				If (isset($input_param['message'])&&isset($input_param['message'][0])&&isset($input_param['message'][0]['value'])
					&&trim($input_param['message'][0]['value'])!= '') {
					$search = array("{{TICKET}}","{{MODE}}","{{DIGITS}}","{{FORE}}","{{BACK}}");
					$replace = array($ticket,$this -> formpara['CaptchaMode'],$this -> formpara['CaptchaDigits'],$this -> formpara['CaptchaFore'],$this -> formpara['CaptchaBack']);
					$CaptMsg = '<p>'.PHP_EOL.'	'.str_replace($search,$replace,$input_param['message'][0]['value']).PHP_EOL.'</p>'.PHP_EOL;
				}

				/* Render in case of "Label position inside input field" */
				$placeholder = '';
				If (trim($label) != '') $placeholder = ' placeholder="'.trim($label).'"';
				/* row 1: input field incl. captcha image and label text */
				SWITCH ($this -> formpara['CaptchaMode']) {
					default:
					case '0':
						$style=' style="padding-left:210px !important; height:70px" ';
					break;

					case '1':
					case '2':
						$style=' style="padding-left:160px !important; height:52px;" ';
					break;

					case '3':
						$style=' style="padding-left:80px !important; height:30px" ';
					break;
				}
				$RightContent  = '<div class="captchabox">'.PHP_EOL.
												 ' <input tabindex="'.$this -> TabIndex.'" '.$warningclass.
												 ' type="text" id="'.$name.'_'.$this -> formpara['FORMsID'].'"'.
												 ' data-ticket="'.$ticket.'"'.
												 ' data-msg-remote="'.$input_param['required'][0]['value'].'"'.
												 ' name="'.$name.'"'.
												 ' value=""'.
												 $placeholder.$style;
				If (isset($input_param['required']) && isset($input_param['required'][0]['value'])) {
					$RightContent .= PHP_EOL.' '.$requiredstr.' data-msg-required="'.$input_param['required'][0]['value'].'"';
				}
				$RightContent .= '>'.PHP_EOL;
				$RightContent .= '	<input  type="hidden"  name="cap'.$name.'" value="'.$ticket.'"'." />".PHP_EOL;
				$RightContent .= $CaptchaImg;
				$RightContent .=  '</div><!-- Close  class="captchabox" -->'.PHP_EOL;
			break;}
			case 4:{/* Google's reCaptcha V2 */
				If (defined('I_am_Online'))  {
					require_once(SENTRA_HOME.'assets/_captcha/reCaptcha.class.php');
					$re = new ReCaptcha();
					$RightContent  = '<div id="'.$name.'_'.$this -> formpara['FORMsID'].'" class="captchabox">'.PHP_EOL;
					$RightContent .=  $re->render().PHP_EOL;
					$RightContent .=  '</div><!-- Close  class="captchabox" -->'.PHP_EOL;
				} else {
					require_once('../../../defaults/script_archive/captcha/reCaptcha.class.php');
					$re = new ReCaptcha();
					$RightContent  = '<div id="'.$name.'_'.$this -> formpara['FORMsID'].'" class="captchabox">'.PHP_EOL;
					$RightContent .=  $re->render().PHP_EOL;
					$RightContent .=  '</div><!-- Close  class="captchabox" -->'.PHP_EOL;
				}
			break;}
			case 5:{/* Color captcha */
				If (defined('I_am_Online'))  {
					require_once(SENTRA_HOME.'assets/_captcha/colorCaptcha.class.php');
					$re = new ColorCaptcha();
					$RightContent  = '<div  id="'.$name.'_'.$this -> formpara['FORMsID'].'" class="captchabox">'.PHP_EOL;
					$RightContent .=  $re->renderColors().PHP_EOL.'<br><br>';
					$RightContent .=  $re->renderHelpMessage().PHP_EOL.'<br><br>';
					$RightContent .=  $re->renderSelect().PHP_EOL;
					$RightContent .=  '</div><!-- Close  class="captchabox" -->'.PHP_EOL;
				} else {
					require_once('../../../defaults/script_archive/captcha/colorCaptcha.class.php');
					$re = new ColorCaptcha();
					$RightContent  = '<div  id="'.$name.'_'.$this -> formpara['FORMsID'].'" class="captchabox">'.PHP_EOL;
					$RightContent .=  $re->renderColors().PHP_EOL.'<br><br>';
					$RightContent .=  $re->renderHelpMessage().PHP_EOL.'<br><br>';
					$RightContent .=  $re->renderSelect().PHP_EOL;
					$RightContent .=  '</div><!-- Close  class="captchabox" -->'.PHP_EOL;

				}
			break;}
		}
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
			$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);

			$CaptchaBox = $this -> FormGriddy -> GetHtml();


			/* row 2: Captcha Message */
			If (trim($CaptMsg) != '') {
				$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
				$this -> FormGriddy -> AddtoXY(1,0,trim($CaptMsg),TRUE);
				$CaptchaBox .= $this -> FormGriddy -> GetHtml();
			}

		if (isset($captcha)) unset($captcha);
		$this -> TabIndex++;
		return  $CaptchaBox;

}

	public function GriddyRenderFileUpload ($label,						/* $label 													*/
																					$name,						/* $input_param['name'][0]['value'] */
																					$input_param,
																					$user_input,
																					$inpcomment,      /* 'Zusatztext' 										*/
																					$requiredstr,
																					$warningclass) {	/* $warningclass,   								*/
		$FileUpload = '';
		If (trim($inpcomment)!= '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
			$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
			$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
			$FileUpload = $this -> FormGriddy -> GetHtml();
			$this -> FormGriddy -> DecoClass[1] = '';
		}
/* Show info on allowed file types and sizes */
		$maxFileSize = $input_param['maxsize'][0]['value'];
		$iniMaxfilesize = ini_get('upload_max_filesize');
		If (!is_bool($iniMaxfilesize) && $iniMaxfilesize < $maxFileSize) {
			$maxFileSize = $this -> return_bytes($iniMaxfilesize);
		}
		$allowed = str_replace(";",", ",$input_param['extension'][0]['value']);
		$allowed = rtrim($allowed,", ");
		$RightContent  = '<div class="uploadmsg">'.PHP_EOL.'<b>'.$GLOBALS['FormError']['permitted_ext'].'</b> '.$allowed.'<br />'.
															'<b>'.$GLOBALS['FormError']['max_upload_size'].'</b> '.FrmData::NiceSize($maxFileSize,1).PHP_EOL.'</div>	<!-- Close class="uploadmsg" -->'.PHP_EOL;
		$RightContent .= '</div><!-- close  class="inpcomment" -->';
		$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
		$FileUpload .= $this -> FormGriddy -> GetHtml();

		$RightContent = '';
		{
		/* See if a file is already uploaded*/
		If (isset($user_input[$name]['showfileinfo']) && $user_input[$name]['showfileinfo']) {
			$RightContent .= '<div class="inpcomment">';
			$RightContent .= 	'	<p>'.PHP_EOL.
												'		<b>'.PHP_EOL.
												'			'.$GLOBALS['FormError']['uploaded_file'].PHP_EOL.
												"		</b> <br />".PHP_EOL.
												'		'.$user_input[$name]['value'].' '.$user_input[$name]['filesizemsg'].PHP_EOL.
												'	</p>'.PHP_EOL;

			/* if an image was uploaded show it as thumbnail */
			If (isset($user_input[$name]['thumbnailpath'])) {
				$src_image = './send_image.php?uID='.base64_encode($this -> formpara['UserID'].":::".$user_input[$name]['value'].":::".SENTRA_SCRIPT_HOME.":::".SENTRA_HOME.":::".$this -> formpara['THUMBFILEPREFIX'].$name);
				$src_image = $user_input[$name]['thumbnailpath'];
				$RightContent .= 	'	<span>'.PHP_EOL.
													'		<img src="'.$src_image.'" alt="'.$user_input[$name]['value'].'" />'.PHP_EOL.
													'	</span>'.PHP_EOL;
			} else {
				$user_input[$name]['thumbnailpath'] = '';
			}
			$RightContent .= '</div><!-- close  class="inpcomment" -->';
	    $uploadedsrc = array();
	    $uploadeddest = array();
			if (isset($_POST['uploadedsrc'])) {
				$uploadedsrc = explode("|",$_POST['uploadedsrc']);
				$uploadeddest = explode("|",$_POST['uploadeddest']);
				if (!$GLOBALS["uploadready"]) {
					$GLOBALS["uploadready"] = true;
					$GLOBALS["uploadedsrc"] = $uploadedsrc;
					$GLOBALS["uploadeddest"] = $uploadeddest;
				}
			}
			if (!in_array($this -> formpara['UserID'].$user_input[$name]['value'],$uploadedsrc)) {
				array_push($GLOBALS["uploadedsrc"],$this -> formpara['UserID'].$user_input[$name]['value']);
				array_push($GLOBALS["uploadeddest"],$user_input[$name]['value']);
			}
			$RightContent .= '<input type="hidden" name="'.$name.'" value=" '.$this -> formpara['UserID'].'|'.$user_input[$name]['value'].'|'.$user_input[$name]['filesizemsg'].
	                    '|'.$user_input[$name]['thumbnailpath'].'|">';
		} Else {
			/* Here: no file uploaded yet*/
			$RightContent .= '<div class="inpcomment">';
			If (isset($input_param['required']) &&
					isset($input_param['required'][0]['value'])) {
				$RightContent .= '<input tabindex="'.$this -> TabIndex.'" type="file" '.$warningclass.' name="'.$name.'" id="'.$input_param['name'][0]['value'].'_'.$this -> formpara['FORMsID'].'"'.$requiredstr.PHP_EOL.
												 ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
			} Else {
				$RightContent .= '<input tabindex="'.$this -> TabIndex.'" type="file" '.$warningclass.' name="'.$name.'" id="'.$input_param['name'][0]['value'].'_'.$this -> formpara['FORMsID'].'"'.$requiredstr.'>'.PHP_EOL;
			}
		}
		If (trim($label) == '') {
			$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
		} Else {
			$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
		}
		$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);


		$FileUpload .= $this -> FormGriddy -> GetHtml();
		$this -> TabIndex++;
		return  $FileUpload;
		}
	}


	private function return_bytes($val) {
		$val = trim($val);
		$last = strtolower($val[strlen($val)-1]);
	  switch($last) {
	      /* The 'G' modifier is available since PHP 5.1.0*/
	      case 'g':
	          $val *= 1024;
	      case 'm':
	          $val *= 1024;
	      case 'k':
	          $val *= 1024;
	  }

	  return $val;
	}

	private function form_get_countries() {
		$countries["North America"]["007"] = 'Anguilla';
		$countries["North America"]["009"] = 'Antigua and Barbuda';
		$countries["North America"]["012"] = 'Aruba';
		$countries["North America"]["016"] = 'Bahamas';
		$countries["North America"]["019"] = 'Barbados';
		$countries["North America"]["022"] = 'Belize';
		$countries["North America"]["024"] = 'Bermuda';
		$countries["North America"]["233"] = 'Virgin Islands, British';
		$countries["North America"]["038"] = 'Canada';
		$countries["North America"]["040"] = 'Cayman Islands';
		$countries["North America"]["052"] = 'Costa Rica';
		$countries["North America"]["055"] = 'Cuba';
		$countries["North America"]["060"] = 'Dominica';
		$countries["North America"]["061"] = 'Dominican Republic';
		$countries["North America"]["064"] = 'El Salvador';
		$countries["North America"]["069"] = 'Falkland Islands (Malvinas)';
		$countries["North America"]["084"] = 'Greenland';
		$countries["North America"]["085"] = 'Grenada';
		$countries["North America"]["086"] = 'Guadeloupe';
		$countries["North America"]["088"] = 'Guatemala';
		$countries["North America"]["092"] = 'Haiti';
		$countries["North America"]["095"] = 'Honduras';
		$countries["North America"]["106"] = 'Jamaica';
		$countries["North America"]["134"] = 'Martinique';
		$countries["North America"]["138"] = 'Mexico';
		$countries["North America"]["143"] = 'Montserrat';
		$countries["North America"]["151"] = 'Netherlands Antilles';
		$countries["North America"]["154"] = 'Nicaragua';
		$countries["North America"]["165"] = 'Panama';
		$countries["North America"]["173"] = 'Puerto Rico';
		$countries["North America"]["180"] = 'Saint Kitts and Nevis';
		$countries["North America"]["181"] = 'Saint Lucia';
		$countries["North America"]["182"] = 'Saint Pierre and Miquelon';
		$countries["North America"]["183"] = 'Saint Vincent and The Grenadines';
		$countries["North America"]["216"] = 'Trinidad and Tobago';
		$countries["North America"]["220"] = 'Turks and Caicos Islands';
		$countries["North America"]["226"] = 'United States';
		$countries["North America"]["227"] = 'United States Minor Outlying Islands';
		$countries["North America"]["234"] = 'Virgin Islands, U.S.';

		$countries["South America"]["010"] = 'Argentina';
		$countries["South America"]["026"] = 'Bolivia';
		$countries["South America"]["030"] = 'Brazil';
		$countries["South America"]["043"] = 'Chile';
		$countries["South America"]["047"] = 'Colombia';
		$countries["South America"]["062"] = 'Ecuador';
		$countries["South America"]["074"] = 'French Guiana';
		$countries["South America"]["091"] = 'Guyana';
		$countries["South America"]["167"] = 'Paraguay';
		$countries["South America"]["168"] = 'Peru';
		$countries["South America"]["202"] = 'Suriname';
		$countries["South America"]["228"] = 'Uruguay';
		$countries["South America"]["231"] = 'Venezuela';

		$countries["Antarctica"]["029"] = 'Bouvet Island';
		$countries["Antarctica"]["076"] = 'French Southern Territories';
		$countries["Antarctica"]["093"] = 'Heard Island and Mcdonald Islands';
		$countries["Antarctica"]["198"] = 'South Georgia and The South Sandwich Islands';

		$countries["Africa"]["003"] = 'Algeria';
		$countries["Africa"]["006"] = 'Angola';
		$countries["Africa"]["023"] = 'Benin';
		$countries["Africa"]["028"] = 'Botswana';
		$countries["Africa"]["034"] = 'Burkina Faso';
		$countries["Africa"]["035"] = 'Burundi';
		$countries["Africa"]["037"] = 'Cameroon';
		$countries["Africa"]["039"] = 'Cape Verde';
		$countries["Africa"]["041"] = 'Central African Republic';
		$countries["Africa"]["042"] = 'Chad';
		$countries["Africa"]["048"] = 'Comoros';
		$countries["Africa"]["049"] = 'Congo';
		$countries["Africa"]["050"] = 'Congo, The Democratic Republic of The';
		$countries["Africa"]["053"] = "Cote D'ivoire";
		$countries["Africa"]["059"] = 'Djibouti';
		$countries["Africa"]["063"] = 'Egypt';
		$countries["Africa"]["065"] = 'Equatorial Guinea';
		$countries["Africa"]["066"] = 'Eritrea';
		$countries["Africa"]["068"] = 'Ethiopia';
		$countries["Africa"]["077"] = 'Gabon';
		$countries["Africa"]["078"] = 'Gambia';
		$countries["Africa"]["081"] = 'Ghana';
		$countries["Africa"]["089"] = 'Guinea';
		$countries["Africa"]["090"] = 'Guinea-bissau';
		$countries["Africa"]["110"] = 'Kenya';
		$countries["Africa"]["119"] = 'Lesotho';
		$countries["Africa"]["120"] = 'Liberia';
		$countries["Africa"]["121"] = 'Libyan Arab Jamahiriya';
		$countries["Africa"]["235"] = 'Wallis and Futuna';
		$countries["Africa"]["236"] = 'Western Sahara';
		$countries["Africa"]["237"] = 'Yemen';
		$countries["Africa"]["127"] = 'Madagascar';
		$countries["Africa"]["128"] = 'Malawi';
		$countries["Africa"]["131"] = 'Mali';
		$countries["Africa"]["135"] = 'Mauritania';
		$countries["Africa"]["136"] = 'Mauritius';
		$countries["Africa"]["137"] = 'Mayotte';
		$countries["Africa"]["144"] = 'Morocco';
		$countries["Africa"]["145"] = 'Mozambique';
		$countries["Africa"]["147"] = 'Namibia';
		$countries["Africa"]["155"] = 'Niger';
		$countries["Africa"]["156"] = 'Nigeria';
		$countries["Africa"]["175"] = 'Reunion';
		$countries["Africa"]["178"] = 'Rwanda';
		$countries["Africa"]["179"] = 'Saint Helena';
		$countries["Africa"]["186"] = 'Sao Tome and Principe';
		$countries["Africa"]["188"] = 'Senegal';
		$countries["Africa"]["190"] = 'Seychelles';
		$countries["Africa"]["191"] = 'Sierra Leone';
		$countries["Africa"]["196"] = 'Somalia';
		$countries["Africa"]["197"] = 'South Africa';
		$countries["Africa"]["201"] = 'Sudan';
		$countries["Africa"]["204"] = 'Swaziland';
		$countries["Africa"]["210"] = 'Tanzania, United Republic of';
		$countries["Africa"]["213"] = 'Togo';
		$countries["Africa"]["217"] = 'Tunisia';
		$countries["Africa"]["222"] = 'Uganda';
		$countries["Africa"]["238"] = 'Zambia';
		$countries["Africa"]["239"] = 'Zimbabwe';

		$countries["Europe"]["002e"] = 'Albania';
		$countries["Europe"]["005e"] = 'Andorra';
		$countries["Europe"]["011e"] = 'Armenia';
		$countries["Europe"]["014e"] = 'Austria';
		$countries["Europe"]["015e"] = 'Azerbaijan';
		$countries["Europe"]["020e"] = 'Belarus';
		$countries["Europe"]["021e"] = 'Belgium';
		$countries["Europe"]["027e"] = 'Bosnia and Herzegovina';
		$countries["Europe"]["033e"] = 'Bulgaria';
		$countries["Europe"]["054e"] = 'Croatia';
		$countries["Europe"]["056e"] = 'Cyprus';
		$countries["Europe"]["057e"] = 'Czech Republic';
		$countries["Europe"]["058e"] = 'Denmark';
		$countries["Europe"]["067e"] = 'Estonia';
		$countries["Europe"]["070e"] = 'Faroe Islands';
		$countries["Europe"]["072e"] = 'Finland';
		$countries["Europe"]["073e"] = 'France';
		$countries["Europe"]["079e"] = 'Georgia';
		$countries["Europe"]["080e"] = 'Germany';
		$countries["Europe"]["082e"] = 'Gibraltar';
		$countries["Europe"]["083e"] = 'Greece';
		$countries["Europe"]["084e"] = 'Greenland';
		$countries["Europe"]["097e"] = 'Hungary';
		$countries["Europe"]["098e"] = 'Iceland';
		$countries["Europe"]["103e"] = 'Ireland';
		$countries["Europe"]["105e"] = 'Italy';
		$countries["Europe"]["109e"] = 'Kazakhstan';
		$countries["Europe"]["300e"] = 'Kosovo';
		$countries["Europe"]["117e"] = 'Latvia';
		$countries["Europe"]["122e"] = 'Liechtenstein';
		$countries["Europe"]["123e"] = 'Lithuania';
		$countries["Europe"]["124e"] = 'Luxembourg';
		$countries["Europe"]["126e"] = 'Macedonia';
		$countries["Europe"]["132e"] = 'Malta';
		$countries["Europe"]["140e"] = 'Moldova, Republic of';
		$countries["Europe"]["141e"] = 'Monaco';
		$countries["Europe"]["301e"] = 'Montenegro';
		$countries["Europe"]["150e"] = 'Netherlands';
		$countries["Europe"]["160e"] = 'Norway';
		$countries["Europe"]["171e"] = 'Poland';
		$countries["Europe"]["172e"] = 'Portugal';
		$countries["Europe"]["176e"] = 'Romania';
		$countries["Europe"]["177e"] = 'Russia';
		$countries["Europe"]["185e"] = 'San Marino';
		$countries["Europe"]["189e"] = 'Serbia and Montenegro';
		$countries["Europe"]["193e"] = 'Slovakia';
		$countries["Europe"]["194e"] = 'Slovenia';
		$countries["Europe"]["199e"] = 'Spain';
		$countries["Europe"]["203e"] = 'Svalbard and Jan Mayen';
		$countries["Europe"]["205e"] = 'Sweden';
		$countries["Europe"]["206e"] = 'Switzerland';
		$countries["Europe"]["218e"] = 'Turkey';
		$countries["Europe"]["223e"] = 'Ukraine';
		$countries["Europe"]["225e"] = 'United Kingdom';
		$countries["Europe"]["094e"] = 'Vatican City';

		$countries["Europa"]["080a"] = 'Deutschland';
		$countries["Europa"]["014a"] = 'Österreich';
		$countries["Europa"]["206a"] = 'Schweiz';
		$countries["Europa"]["150a"] = 'Niederlande';
		$countries["Europa"]["058a"] = 'Dänemark';
		$countries["Europa"]["021a"] = 'Belgien';
		$countries["Europa"]["199a"] = 'Spanien';
		$countries["Europa"]["205a"] = 'Schweden';
		$countries["Europa"]["122a"] = 'Liechtenstein';
		$countries["Europa"]["073a"] = 'Frankreich';
		$countries["Europa"]["002a"] = 'Albanien';
		$countries["Europa"]["005a"] = 'Andorra';
		$countries["Europa"]["011a"] = 'Armenien';
		$countries["Europa"]["015a"] = 'Aserbaidschan';
		$countries["Europa"]["020a"] = 'Weißrussland';
		$countries["Europa"]["027a"] = 'Bosnien Herzegovina';
		$countries["Europa"]["033a"] = 'Bulgarien';
		$countries["Europa"]["054a"] = 'Kroatien';
		$countries["Europa"]["056a"] = 'Zypern';
		$countries["Europa"]["057a"] = 'Tschechien';
		$countries["Europa"]["067a"] = 'Estland';
		$countries["Europa"]["070a"] = 'die Färöer';
		$countries["Europa"]["072a"] = 'Finnland';
		$countries["Europa"]["079a"] = 'Georgien';
		$countries["Europa"]["082a"] = 'Gibraltar';
		$countries["Europa"]["083a"] = 'Griechenland';
		$countries["Europa"]["084a"] = 'Grönland';
		$countries["Europa"]["097a"] = 'Ungarn';
		$countries["Europa"]["098a"] = 'Island';
		$countries["Europa"]["103a"] = 'Irland';
		$countries["Europa"]["105a"] = 'Italien';
		$countries["Europa"]["109a"] = 'Kasachstan';
		$countries["Europa"]["300a"] = 'Kosovo';
		$countries["Europa"]["117a"] = 'Lettland';
		$countries["Europa"]["123a"] = 'Litauen';
		$countries["Europa"]["124a"] = 'Luxemburg';
		$countries["Europa"]["126a"] = 'Mazedonien';
		$countries["Europa"]["132a"] = 'Malta';
		$countries["Europa"]["140a"] = 'Moldavien';
		$countries["Europa"]["141a"] = 'Monaco';
		$countries["Europa"]["301a"] = 'Montenegro';
		$countries["Europa"]["150a"] = 'Niederlande';
		$countries["Europa"]["160a"] = 'Norwegen';
		$countries["Europa"]["171a"] = 'Polen';
		$countries["Europa"]["172a"] = 'Portugal';
		$countries["Europa"]["176a"] = 'Rumänien';
		$countries["Europa"]["177a"] = 'Russland';
		$countries["Europa"]["185a"] = 'San Marino';
		$countries["Europa"]["189a"] = 'Serbien und Montenegro';
		$countries["Europa"]["193a"] = 'Slovakien';
		$countries["Europa"]["194a"] = 'Slovenien';
		$countries["Europa"]["203a"] = 'Spitzbergen';
		$countries["Europa"]["218a"] = 'Türkei';
		$countries["Europa"]["223a"] = 'Ukraine';
		$countries["Europa"]["225a"] = 'England';
		$countries["Europa"]["094a"] = 'Vatikan Stadt';

		$countries["Asia"]["001"] = 'Afghanistan';
		$countries["Asia"]["011"] = 'Armenia';
		$countries["Asia"]["015"] = 'Azerbaijan';
		$countries["Asia"]["017"] = 'Bahrain';
		$countries["Asia"]["018"] = 'Bangladesh';
		$countries["Asia"]["025"] = 'Bhutan';
		$countries["Asia"]["031"] = 'British Indian Ocean Territory';
		$countries["Asia"]["032"] = 'Brunei Darussalam';
		$countries["Asia"]["036"] = 'Cambodia';
		$countries["Asia"]["044"] = 'China';
		$countries["Asia"]["056"] = 'Cyprus';
		$countries["Asia"]["079"] = 'Georgia';
		$countries["Asia"]["096"] = 'Hong Kong';
		$countries["Asia"]["099"] = 'India';
		$countries["Asia"]["100"] = 'Indonesia';
		$countries["Asia"]["101"] = 'Iran';
		$countries["Asia"]["102"] = 'Iraq';
		$countries["Asia"]["104"] = 'Israel';
		$countries["Asia"]["107"] = 'Japan';
		$countries["Asia"]["108"] = 'Jordan';
		$countries["Asia"]["109"] = 'Kazakhstan';
		$countries["Asia"]["112"] = 'Korea, North';
		$countries["Asia"]["113"] = 'Korea, South';
		$countries["Asia"]["114"] = 'Kuwait';
		$countries["Asia"]["115"] = 'Kyrgyzstan';
		$countries["Asia"]["116"] = 'Laos';
		$countries["Asia"]["118"] = 'Lebanon';
		$countries["Asia"]["125"] = 'Macau';
		$countries["Asia"]["129"] = 'Malaysia';
		$countries["Asia"]["130"] = 'Maldives';
		$countries["Asia"]["142"] = 'Mongolia';
		$countries["Asia"]["146"] = 'Myanmar';
		$countries["Asia"]["149"] = 'Nepal';
		$countries["Asia"]["161"] = 'Oman';
		$countries["Asia"]["162"] = 'Pakistan';
		$countries["Asia"]["164"] = 'Palestinian Territory';
		$countries["Asia"]["169"] = 'Philippines';
		$countries["Asia"]["174"] = 'Qatar';
		$countries["Asia"]["177"] = 'Russia';
		$countries["Asia"]["187"] = 'Saudi Arabia';
		$countries["Asia"]["192"] = 'Singapore';
		$countries["Asia"]["200"] = 'Sri Lanka';
		$countries["Asia"]["207"] = 'Syria';
		$countries["Asia"]["208"] = 'Taiwan';
		$countries["Asia"]["209"] = 'Tajikistan';
		$countries["Asia"]["211"] = 'Thailand';
		$countries["Asia"]["212"] = 'Timor-leste';
		$countries["Asia"]["218"] = 'Turkey';
		$countries["Asia"]["219"] = 'Turkmenistan';
		$countries["Asia"]["224"] = 'United Arab Emirates';
		$countries["Asia"]["229"] = 'Uzbekistan';
		$countries["Asia"]["232"] = 'Vietnam';
		$countries["Asia"]["237"] = 'Yemen';

		$countries["Oceania"]["004"] = 'American Samoa';
		$countries["Oceania"]["013"] = 'Australia';
		$countries["Oceania"]["045"] = 'Christmas Island';
		$countries["Oceania"]["046"] = 'Cocos (Keeling) Islands';
		$countries["Oceania"]["051"] = 'Cook Islands';
		$countries["Oceania"]["302"] = 'Easter Island';
		$countries["Oceania"]["071"] = 'Fiji';
		$countries["Oceania"]["087"] = 'Guam';
		$countries["Oceania"]["100"] = 'Indonesia';
		$countries["Oceania"]["111"] = 'Kiribati';
		$countries["Oceania"]["133"] = 'Marshall Islands';
		$countries["Oceania"]["139"] = 'Micronesia, Federated States of';
		$countries["Oceania"]["148"] = 'Nauru';
		$countries["Oceania"]["152"] = 'New Caledonia';
		$countries["Oceania"]["153"] = 'New Zealand';
		$countries["Oceania"]["157"] = 'Niue';
		$countries["Oceania"]["158"] = 'Norfolk Island';
		$countries["Oceania"]["159"] = 'Northern Mariana Islands';
		$countries["Oceania"]["163"] = 'Palau';
		$countries["Oceania"]["166"] = 'Papua New Guinea';
		$countries["Oceania"]["170"] = 'Pitcairn';
		$countries["Oceania"]["075"] = 'French Polynesia';
		$countries["Oceania"]["184"] = 'Samoa';
		$countries["Oceania"]["195"] = 'Solomon Islands';
		$countries["Oceania"]["214"] = 'Tokelau';
		$countries["Oceania"]["215"] = 'Tonga';
		$countries["Oceania"]["221"] = 'Tuvalu';
		$countries["Oceania"]["230"] = 'Vanuatu';

		return $countries;
	}

	private function form_userinputline2csv($input_param,$user_input){
		$csvstring="";
		$name = $input_param['name'][0]['value'];
		If (isset($input_param['label']) && isset($input_param['label'][0]['value'])) {
			$csvstring=$name.";".str_replace(";",".,",$input_param['label'][0]['value']).";";
		}
		$value="";
		If (isset($user_input[$name]) && isset($user_input[$name]['value']))
			$value = $user_input[$name]['value'];
		SWITCH (trim($input_param['type'][0]['value'])) {
				case "confirmation":
				break;

				case "password":
				break;

				case "hidden":
					$csvstring="";
				break;

				case "text":
				case "email":
					If (isset($input_param['maxlength']) && isset($input_param['maxlength'][0]['value'])) {
						/* Check if received value has more character than specified by maxlength*/
						If (strlen($value) > $input_param['maxlength'][0]['value'])
							$csvstring.="Warning: Besucher hat Formular manipuliert, weil Eingabewert l?er ist als in 'maxlength' spezifiziert!";
					}
				break;

				case "textarea":
				break;

				case "spamquestion":
				break;

				case "radio":/*form_userinputline2csv*/
					$value = '';
					for ($k=0; $k < count($user_input[$name]['option']); $k++) {
						If ($user_input[$name]['option'][$k]['radiocheck'][0]['value'] == 'True') {
							$value = $input_param['option'][$k]['radiolabel'][0]['value'].
														" (Wert = ".$input_param['option'][$k]['radiovalue'][0]['value'].")";
						};
					}
				break;

				case "sendmessageto":	/* function form_userinputline2csv*/
					for ($k=0; $k < count($input_param['index']); $k++) {
						If (isset($user_input[$name]) && isset($user_input[$name]['value'])) {
							If ($input_param['index'][$k]['value'] == $user_input[$name]['value']) {
								$value = $this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname'];
								$GLOBALS["sendemailto"] = $this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['address'];
							}
						} ElseIf ($input_param['defaultvalue'][0]['value'] == $input_param['index'][$k]['value']) {
							$value = $this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname'];
							$GLOBALS["sendemailto"]  = $this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['address'];
						}
					}
				break;

				case "countryselect":		/* input2csv*/
				break;

				case "selectbox": /*get csv values*/
					If (isset($user_input[$name]) && isset($user_input[$name]['value']))
						$value = $user_input[$name]['value'];
					If (isset($input_param['optgroup'])) {
						for ($og=0; $og < count($input_param['optgroup']); $og++) {
							If (isset($user_input['optgroup'][$og]) && isset($user_input['optgroup'][$og]['option'])) {
								for ($k=0; $k < count($input_param['optgroup'][$og]['option']); $k++) {
									If (isset($user_input['optgroup'][$og]) &&
											isset($user_input['optgroup'][$og]['option'][$k]) &&
											isset($user_input['optgroup'][$og]['option'][$k]['selected']) &&
											$user_input['optgroup'][$og]['option'][$k]['selected']) {
												$value = $input_param['optgroup'][$og]['option'][$k]['optionlabel'][0]['value'];
									}
								}
							}
						}
					}
				break;

				case "s_checkbox":
					If (isset($user_input[$name]) && isset($user_input[$name]['value']))
						$value = $user_input[$name]['value'];
				break;

				case "checkbox":
				break;

				case "file":		/* input2csv*/
					If (isset($user_input[$name]) && isset($user_input[$name]['name']) && isset($user_input[$name]['filesizemsg'])) {
						$value = $user_input[$name]['name'].$user_input[$name]['filesizemsg'];
					}
				break;

				case "sendbutton":
					$csvstring="";
				break;

				default:
						$csvstring="Warning: Besucher hat Formular manipuliert, weil empfangener Parameter nicht spezifiziert war.!";
				break;
			}
			/* If user has entered a value take this on instead*/
			If ($value != "")	$csvstring.=str_replace(";",".,",$value);

		return $csvstring;
	}
	private function form_userinputgroup2csv(	$fieldset,		/* pointer to input groups of current fieldset */
																						$user_input){	/* pointer to user_input array for received data of selected fieldset */
		$csvstring = array();
		If (isset($fieldset['inputgroup'])) {
			$l = 0;
			for ($ig = 0; $ig < count($fieldset['inputgroup']); $ig++) {
					/* Each input group contains a number of input lines*/
				$nInpElements = count($fieldset['inputgroup'][$ig]['input']);
				for ($ie=0; $ie < $nInpElements; $ie++) {	/* process 4 input elements per line at most*/
					$csvstring[$l++]=$this -> form_userinputline2csv($fieldset['inputgroup'][$ig]['input'][$ie],

																									$user_input['inputgroup'][$ig]['input'][$ie]);   /* pointer to results array for received data of selected input line*/
				}
			}
		}
		return $csvstring;
	}

	public function form_userinput2csv(				/* IN: array with form parameter*/
															$user_input) {		/* IN: pointer to results array for received data of selected input line*/
		$csvstring = array();														/* RETURN: string array with Labels and corresponding input values*/
		$nTABs = count($this -> formXMLdata['page'][0]['tab']);
		for ($it=0; $it < $nTABs; $it++) {
			If (isset($this -> formXMLdata['page']) &&
					isset($this -> formXMLdata['page'][0]) &&
					isset($this -> formXMLdata['page'][0]['tab']) &&
					isset($this -> formXMLdata['page'][0]['tab'][$it]) &&
					isset($this -> formXMLdata['page'][0]['tab'][$it]['caption']) &&
					isset($this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]) &&
					isset($this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]['value'])) {
					$csvstring[$it]['tabcaption'] = $this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]['value'];
			} Else {
					$csvstring[$it]['tabcaption'] = "";
			}
			/* start processing of fieldsets:*/
			for ($fs=0; $fs < count($this -> formXMLdata['page'][0]['tab'][$it]['fieldset']); $fs++) {
				If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value']!="") {
					$csvstring[$it][$fs]['fslegend'] = $this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'];
				} Else {
					$csvstring[$it][$fs]['fslegend'] = "";
				}
				$csvstring[$it][$fs]['input'] = $this -> form_userinputgroup2csv($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs],	/* pointer to input groups of current fieldset */
																																				 $user_input['page'][0]['tab'][$it]['fieldset'][$fs]);	/* pointer to user_input array for received data of selected fieldset */
			}
		}
		return $csvstring;
	}
	private function AddWarningmessage($name,$warningmessage) {
		$ID = $name.'_'.$this -> formpara['FORMsID'].'-error';
		$this -> WarningText .= '<div class="error error-link" id="'.$ID.'"/>'.$warningmessage.'</div>';
	}

	private function form_validEmail(	$name,						/* INP: variables name */
																		$email,						/* INP: email string to be validated*/
																		$label,						/* INP: label shown at the form*/
																		$required) {			/* INP: Flag indicatibg if this input field was marked as 'required'*/

	/* found at: http://www.linuxjournal.com/article/9585?page=0,3*/
		/**
		Validate an email address.
		Provide email address (raw input)
		Returns true if the email address has the email
		address format and the domain exists.
		**/
		/* Extended by RHo: check against anonymous email provider */
		$anymemailisplist = array('@mailnesia.com',	/* mailnesia.com*/
															'@hmamail.com',		/* @hidemyass.com'*/
															'@hidemyass.com',
															'@mailcatch.com',
															'@dispostable.com',
															'@hulapla.de',
															'@spambog.com',
															'@discardmail.com',
															'@mail.ru',
															'@mailmetrash.com',
															'@mt2014.com',
															'@mailcatch.com',
															'@mail.ru',
															'@vmakemore.com',
															'@noscabies.org',
															'@spamavert.com',
															'@cust.in',
															'@uzetwlhwjhc.com',
															'@live.com',
															'@spamfree24.org',
															'@trashmail.ws',
															'@mailcatch.com',
															'@silkroadproxy.com',
															'@mmmmail.com',
															'@silkroadproxy.com',
															'@mailcatch.com',
															'@vjrjjtzrlht.com',
															'@spambog.ru',
															'@live.com',
															'@brennendesreich.de',
															'@mailinator.com',
															'@0815.ru',
															'@vcsshnzujrz.com',
															'@poczta.pl',
															'@rbmail.co.uk',
															'@trash-mail.com',
															'@5andb.com',
															'@superstachel.de',
															'@brennendesreich.de',
															'@yapmap.net',
															'@wp.pl',
															'@bund.us',
															'@poczta.fm',
															'@silkroadproxy.com',
															'@scorpions.co.uk',
															'@belkin-router.de',
															'@nomorekids.com',
															'@sazonline.com',
															'@seox.se',
															'@spamavert.com',
															'@pcdll.com',
															'@ama-trade.de',
															'@silkroadproxy.com',
															'@zmtbbyqcr.pl',
															'@yourbusinesstips.biz',
															'@adultesex.net',
															'@bigstring.com',
															'@efemsjuhnxa.com',
															'@verygrumpy.co.uk',
															'@e-postkasten.eu',
															'@fastfords.co.uk',
															'@palacefans.com',
															'@e-postkasten.de',
															'@163.com',
															'@freeolamail.com',
															'@louboinhomment.info',
															'@bollouisvuittont.info',
															'@rediff.com',
															'@uk.pl',
															'@onet.eu',
															'@nokiamail.com',
															'@loonies.co.uk',
															'@ukgolfers.com',
															'@interia.eu',
															'@grandads.co.uk',
															'@spambog.com',
															'@krakowart.com',
															'@pupsan.myjino.ru',
															'@ssteermail.com',
															'@satabmail.com',
															'@hrcwmdcekva.com',
															'@pnwazpjysyn.com',
															'@mailrerrs.com'
														 );
	/* von http://www.email-wegwerf.de/trashmailliste.txt:
	@mailexpire.com @spamtrail.com @0815.ru @10minutemail.com
	@3d-painting.com @antichef.net @BeefMilk.com @bio-muesli.info
	@bio-muesli.net @cust.in @despammed.com @DingBone.com @discardmail.com
	@discardmail.de @dontsendmespam.de @edv.to @emailias.com @ero-tube.org
	@film-blog.biz @FudgeRub.com @geschent.biz @great-host.in
	@guerillamail.org @imails.info @jetable.com @kulturbetrieb.info
	@kurzepost.de @LookUgly.com @mail4trash.com @mailinator.com
	@mailnull.com @nervmich.net @nervtmich.net @nomail2me.com @nurfuerspam.de
	@objectmail.com @owlpic.com @proxymail.eu @rcpt.at @recode.me @s0ny.net
	@sandelf.de @SmellFear.com @sneakemail.com @snkmail.com @sofort-mail.de
	@spam.la @spambog.com @spambog.de @spambog.ru @spamex.com @spamgourmet.com
	@spammotel.com @squizzy.de @super-auswahl.de @teewars.org @tempemail.net
	@trash-mail.at @trash-mail.com @trash2009.com @trashmail.at @trashmail.de
	@trashmail.me @trashmail.net @trashmail.ws @watch-harry-potter.com
	@watchfull.net @wegwerf-email.net @wegwerfadresse.de @wegwerfmail.de
	@wegwerfmail.net @wegwerfmail.org @willhackforfood.biz @yopmail.com
	*/
	/* prepare emaillist for looking up via array_key_exists() */
	$anymemailisplist = array_flip($anymemailisplist);
		$isValid = true;
		$lenemail = strlen($email);
		$warningmessage = '"'.$label.'" ';

			If ($lenemail < 5 ) {
					If ($required) {
						$isValid = false;
						$warningmessage = '<b>"'.$label.'"</b> ';
						$warningmessage .= $GLOBALS['FormError']['not_enough_char'].'<br />';
					} Else If ($lenemail > 0) {
						$isValid = false;
						$warningmessage .= $GLOBALS['FormError']['uncomplete'].'<br />';
					}
			} Else {
				$atIndex = strrpos($email, "@");
				if (is_bool($atIndex) && !$atIndex) {
				   $isValid = false;
				   $warningmessage .= $GLOBALS['FormError']['missingat']."<br />";
				}	else {
					$domain = substr($email, $atIndex+1);
					$local = substr($email, 0, $atIndex);
					$localLen = strlen($local);
					$domainLen = strlen($domain);
					$warningmessage = "";
					/* check for one-time or spam email addresses */
					if ($localLen < 1) {
						/* local part length exceeded*/
						$isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpart0']);
				  } Else if ($localLen > 64) {
					   /* local part length exceeded*/
					   $isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpart64']);
					} else if ($local[0] == '.' && $local[$localLen-1] == '.') {
					  /* local part starts and ends with '.'*/
					  $isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpartdot1']);
					} else if ($local[0] == '.') {
					   /* local part starts with '.'*/
					  $isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpartdot2']);
					} else if ($local[$localLen-1] == '.') {
						/* local part starts or ends with '.'*/
						$isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpartdot3']);
					} else if (preg_match('/\\.\\./', $local)) {
						/* local part has two consecutive dots*/
						$isValid = false;
						$dotdotpos = strpos($local,"..");
						$lokal =substr($local,0,$dotdotpos).'<span style="color:#FF8;background:#800">..</span>'.substr($local,$dotdotpos+2);
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpartdot4']);
					} else if ($domainLen < 1 || $domainLen > 255) {
					  /* domain part length exceeded*/
					  $isValid = false;
						$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpartdot4']);

					} else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain)) {
					  /* character not valid in domain part*/
					  $isValid = false;
						$warningmessage .= str_replace('{{domainpart}}',$domain,$GLOBALS['FormError']['domain1']);
					} else if (!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/', str_replace("\\\\","",$local))) {
					   /* character not valid in local part unless */
					   /* local part is quoted*/
					  if (!preg_match('/^"(\\\\"|[^"])+"$/',
					       str_replace("\\\\","",$local))) {
					     $isValid = false;
							$warningmessage .= str_replace('{{localpart}}',$local,$GLOBALS['FormError']['localpart2']);
					  }
					} else if (array_key_exists('@'.strtolower($domain), $anymemailisplist)) {
					  $isValid = false;
						$warningmessage .= str_replace('{{domainpart}}',$domain,$GLOBALS['FormError']['isspamdomain']);
					}
					/* See if domain exists */
					If (function_exists("checkdnsrr")) {
						if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A"))) {
						  /* domain not found in DNS*/
						  $isValid = false;
							$warningmessage .= str_replace('{{domainpart}}',$domain,$GLOBALS['FormError']['unknowndomain']);
						}
					} Else If ($isValid && function_exists("getmxrr")) {
						$mxhosts = array();
						$state = getmxrr($domain, $mxhosts);
						If (!$state) {
						  $isValid = false;
							$warningmessage .= str_replace('{{domainpart}}',$domain,$GLOBALS['FormError']['unknowndomain']);
						}
					}
				}
			}

		return array($isValid,$warningmessage);
	}
	private function form_analyze_single_input(	$GETPOSTvars,			/* received POST and/or GET data*/
	                             								$input_param,			/* I: XML specification of selected input line*/
	                              							$VCARD_values) {	/* O: array with received user input indexed by  form var names*/


		If ($input_param['type'][0]['value']=="captcha") {
			If (isset($input_param['required']) &&
					isset($input_param['required'][0]) &&
					!isset($input_param['required'][0]['value'])) {
				$input_param['required'][0]['value'] = "Eingabe ist wegen des Schutzes vor Spammern notwendig";
			}
		}
		$name = $input_param['name'][0]['value'];
		$user_input[$name]['status'] = TRUE;
		$user_input['status'] = TRUE;
		$user_input[$name]['value'] = "";
		$user_input[$name]['warningmsg'] = "";
		$VCARD_values[$name]= "";
		If (isset($input_param['label']) &&
				isset($input_param['label'][0]) &&
				isset($input_param['label'][0]['value'])) {/* Analyze all types but "sendbutton" and "hidden"; "sendbutton" and "hidden" don't have a label tag*/
			/* Processing all kind of input types*/
			$label = $input_param['label'][0]['value'].": ";
			If (isset($GETPOSTvars[$name])) {	/* Continue if user did supply a value for this field */
				If (is_array($GETPOSTvars[$name])) { /* IF file upload ... */
					If (isset($GETPOSTvars[$name]["name"])) {
						/* Then it contains an array $_FILES which is present in case of file upload */
						$user_input[$name]['value'] = $GETPOSTvars[$name]["name"];/* Use the filename as user's input value */
						$user_input[$name]['type'] = $GETPOSTvars[$name]['type'];
						$user_input[$name]['size'] = $GETPOSTvars[$name]['size'];
						$user_input[$name]['tmp_name'] = $GETPOSTvars[$name]['tmp_name'];	/* Supply all other upload params as well */
						$user_input[$name]['error'] = $GETPOSTvars[$name]['error'];
						$user_input[$name]['dstfile'] = $GETPOSTvars[$name]["dstfile"];
						If (isset($GETPOSTvars[$name]['thumbnailpath']))
							$user_input[$name]['thumbnailpath'] = $GETPOSTvars[$name]['thumbnailpath'];
					}
				} Else {
					/* Here: NO file upload; instead we got input from ordinary input fields */

					$user_input[$name]['value'] = FrmData::PrepareValue ($GETPOSTvars[$name]);	/* copy the entered value into the user input array. In case of uploaded files this is an array! */
					$GLOBALS["FORMvars"][$name] = $user_input[$name]['value'];
					If ($GETPOSTvars[$name]=="" &&
							isset($input_param['required']) &&
							isset($input_param['required'][0]) &&
							isset($input_param['required'][0]['value']) &&
							$input_param['required'][0]['value']!="") {
						$user_input[$name]['status'] = FALSE;
						$user_input[$name]['value'] = "";	/* copy empty value into the user input array*/
						$user_input[$name]['warningmsg'] = $input_param['required'][0]['value']; /* copy the warning message for this required input field*/
					}
				}
			} Else {
				/* Here: no value was entered.*/
				/* So if a value was required indicate the missing value by setting the status flag to FALSE*/
				If (isset($input_param['required']) &&
						isset($input_param['required'][0]) &&
						isset($input_param['required'][0]['value']) &&
						$input_param['required'][0]['value']!="") {
					$user_input[$name]['status'] = FALSE;
					$user_input[$name]['value'] = "";	/* copy empty value into the user input array*/
					$user_input[$name]['warningmsg'] = $input_param['required'][0]['value']; /* copy the warning message for this required input field*/
				}
			}
			If ($input_param['type'][0]['value']=="captcha") {
				$user_input[$name]['status']=true;
			}
			/* If the value was entered check if the value is inside the definition range:*/
			If ($user_input[$name]['status']) {
				SWITCH (trim($input_param['type'][0]['value'])) {

					case "countryselect":	 /* function form_analyze_single_input */
						list($region,  $index) = explode("-!_",$GETPOSTvars[$name]);
						If ($region=="USERVALUE") {
							If ($index == 0) {	/* visitor did not enter a selection therefore investigate if selection was required*/
								If (isset($input_param['required']) &&
										isset($input_param['required'][0]) &&
										isset($input_param['required'][0]['value']) &&
													$input_param['required'][0]['value']!="") {
									$user_input[$name]['value'] = FrmData::PrepareValue ($input_param['uservalue'][0]['value']);
									$user_input['status'] = FALSE;
									$user_input[$name]['status'] = FALSE;
									$user_input[$name]['warningmsg'] = $input_param['required'][0]['value']; /* copy the warning message for this required input field*/
								} Else {	/* do nothing if selection was not required*/
								}
							}
						} Else {	/* Here: $region!="USERVALUE" means the visitor made a selection*/
							$countries = $this -> form_get_countries();
							If (isset($countries[$region])) {	/* check if the transmitted region exists in our database*/
								If (isset($countries[$region][$index])) {	/* check if the transmitted country index exists in our database*/
										$user_input[$name]['selected'][0]['value'] = TRUE;
										$user_input[$name]['value'] = FrmData::PrepareValue ($countries[$region][$index]);

								} Else {	/* The transmitted country index does NOT exist in our database ==> visitor manipulated the form*/
									$user_input[$name]['value'] = FrmData::PrepareValue ($input_param['uservalue'][0]['value']);
									$user_input['status'] = FALSE;
									$user_input[$name]['status'] = FALSE;
									$user_input[$name]['warningmsg'] = "unknown country index";
									$user_input[$name]['selected'][0]['value'] = TRUE;
								}
							} Else {	/* The transmitted region does NOT exist in our database ==> visitor manipulated the form*/
									$user_input[$name]['value'] = FrmData::PrepareValue ($input_param['uservalue'][0]['value']);
									$user_input['status'] = FALSE;
									$user_input[$name]['status'] = FALSE;
									$user_input[$name]['warningmsg'] = "unknown world region";
									$user_input[$name]['selected'][0]['value'] = TRUE;
							}
						}
					break;

					case "confirmation";	 /* function form_analyze_single_input */
						If (isset($input_param['required']) &&
								isset($input_param['name']) &&
								isset($input_param['name'][0]) &&
								isset($input_param['name'][0]['value']) &&
								$GETPOSTvars[$input_param['name'][0]['value']]!='confirmed') {
							/* user did NOT confirm the requested legal text*/
							$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							$user_input[$name]['status'] = FALSE;
						}
					break;

					case "password":	 /* function form_analyze_single_input */
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								$input_param['required'][0]['value']!="" && !isset($GETPOSTvars[$name])) {
							/* user did NOT enter password*/
							$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							$user_input[$name]['status'] = FALSE;
						}
					break;

					case "text":
					case "textarea":	 /* function form_analyze_single_input */
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								$input_param['required'][0]['value']!="" && !isset($GETPOSTvars[$name])) {
							/* user did NOT enter text*/
							$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							$user_input[$name]['status'] = FALSE;
						}
					break;

					case "captcha":	 /* function form_analyze_single_input */

						SWITCH ($this -> formpara['CaptchaMode']) {
							case 0:
							case 1:
							case 2:
							case 3: {/* Grafic captcha */

						$this -> TICKET = $GETPOSTvars['capcaptcha_value'];
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								$input_param['required'][0]['value']!="") {/* user input is required*/

							If (isset($GETPOSTvars[$name])) {/* user has entered a captcha value*/
								$captcha = new captcha();

								if (!$captcha->CheckCode($this -> TICKET,$GETPOSTvars[$name])) {
									$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
									$user_input[$name]['status'] = FALSE;
								}
							} Else {
							/* user did NOT enter the requested captcha value*/
								$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
								$user_input[$name]['status'] = FALSE;
							}
						} Else {
							/* captcha value is not required*/
						}
						break;
						}
						case 4: {/* reCaptcha */
							$response = STR_PostVars('g-recaptcha-response');
							require_once(SENTRA_HOME.'assets/_captcha/reCaptcha.class.php');
							$cap = new ReCaptcha();
							if(!empty($response)) {
								$verified = $cap->verify($response);
							}
							if (!$verified) {
								$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
								$user_input[$name]['status'] = FALSE;
							} else {
								#$user_input[$name]['status'] = true;
							}
						break;
						}
						case 5: {/* reCaptcha */
							require_once(SENTRA_HOME.'assets/_captcha/colorCaptcha.class.php');
							$cap = new ColorCaptcha();
							$result = $cap->verify(STR_PostVars('ClrId'),STR_PostVars('colors'));
							If (STR_PostVars('color-response') == "" || !$result) {
								$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
								$user_input[$name]['status'] = FALSE;
							}
						break;
						}
					}
					break;

					case "email": /* function form_analyze_single_input */
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								$input_param['required'][0]['value']!="" && !isset($GETPOSTvars[$name])) {
							/* user did NOT enter an email address*/
							$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							$user_input[$name]['status'] = FALSE;
						}
						/*consistency check of given email address:*/
						If (isset($GETPOSTvars[$name])) {
							$required = FALSE;
							If (isset($input_param['required']) &&
									isset($input_param['required'][0]) &&
									isset($input_param['required'][0]['value']))
								$required = TRUE;
								list($user_input[$name]['status'], $user_input[$name]['warningmsg']) = $this -> form_validEmail($name, $GETPOSTvars[$name], $label, $required);
						}
					break;

					case "radio":	 /* function form_analyze_single_input */
					/* Check which option was selected*/
					If (isset($GETPOSTvars[$name])) {
	/*
	    [name][0][value] => radiobox
	    [boxheight][0][value] => 0
	    [option][0][radiolabel][0][value] => Option 1
	               [radiovalue][0][value] => op1
	               [radiocheck][0][value] => False
	    [option][1][radiolabel][0][value] => Option 2
	               [radiovalue][0][value] => op2
	               [radiocheck][0][value] => False
	*/
						foreach($input_param['option'] as $k => $value) {
								If ($input_param['option'][$k]['radiovalue'][0]['value'] == /* defined values*/
										$GETPOSTvars[$name]) {/* entered by user*/
									$user_input[$name]['option'][$k]['radiocheck'][0]['value'] = 'True';
									$user_input[$name]['status'] = TRUE;
								} Else {
									$user_input[$name]['option'][$k]['radiocheck'][0]['value'] = 'False';
								}
						}

					} Else {/* no value entered*/
						/* If the parameter was required we send a message to the user*/
							If (isset($input_param['required']) &&
									isset($input_param['required'][0]) &&
									isset($input_param['required'][0]['value']) &&
						 		$input_param['required'][0]['value']!="") {
								$user_input[$name]['status'] = FALSE;
								$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							}
					}
					break;

					case "checkbox":	 /* function form_analyze_single_input */
					break;

					case "s_checkbox": {/* function form_analyze_single_input */
						If ($user_input[$name]['value'] != "") { /* A value is received only if the box was selected!*/
							$user_input[$name]['value'] = base64_decode($user_input[$name]['value']);
							If ($user_input[$name]['value'] == $input_param['option'][0]['optionvalue'][0]['value']) {
								$user_input['option'][0]['checked'] = TRUE;
							} Else {
								$user_input['option'][0]['checked'] = FALSE;
							}

						} Else {		/* There is no received value if the box was not selected!*/
							$user_input['option'][0]['checked'] = FALSE;
						}
						If (!$user_input['option'][0]['checked']) {
							If (isset($input_param['required']) &&
									isset($input_param['required'][0]) &&
									isset($input_param['required'][0]['value']) &&
									trim($input_param['required'][0]['value'])!="") {
								/* user did NOT activate the required check box */
								$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
								$user_input[$name]['status'] = FALSE;
							} Else {
								$user_input[$name]['warningmsg'] = '';
								$user_input[$name]['status'] = TRUE;
							}
						}
					}
					break;

					case "selectbox":	{ /* function form_analyze_single_input */
						If (isset($input_param['optgroup'])) {
							$user_input[$name]['status'] = TRUE;
							$user_input['status'] = TRUE;
							$user_input[$name]['selectionchosen'] = TRUE;
							list($og,  $k) = explode("-!_",$GETPOSTvars[$name]);
							$user_input['optgroup'][$og]['option'][$k]['selected'] = FALSE;
							If ($og == 0 && $k == 0) {	/* This means the user did not make any selection */

								$user_input[$name]['value'] = "keine Auswahl getroffen";
								$user_input[$name]['selectionchosen'] = FALSE;
								/* If a selection is required we have to ask the user again to make a selection => another round of rendering is required */
								If (isset($input_param['required']) &&
										isset($input_param['required'][0]) &&
										isset($input_param['required'][0]['value']) &&
										$input_param['required'][0]['value']!="") {
									$user_input[$name]['status'] = FALSE;
									$user_input['status'] = FALSE;
									$user_input[$name]['warningmsg'] = $input_param['required'][0]['value']; /* copy the warning message for this required input field*/
								}

							} Else {
								/* Here, the user made a selection */
								$user_input[$name]['value'] = $input_param['optgroup'][$og]['option'][$k]['optionvalue'][0]['value'];
								$user_input['optgroup'][$og]['option'][$k]['selected'] = TRUE;
							}

						}
					}
					break;

					case "multipleselectbox":	{ /* function form_analyze_single_input */
	/*	 Alternative von hier: http://c82.net/samples/checklist-samples.html
	#					$HTML = '<ul class="s_checklist" style="height:'.$input_param['boxheight'][0]['value'].';">'.PHP_EOL;
	#					for ($k=0; $k < count($input_param['option']); $k++) {
	#						$HTML .= '<li><label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'."\r\n".
	#						'<input id="'.$name.$k.'_'.$this -> formpara['FORMsID'].
	#						'" type="checkbox'.
	#						'" name="'.$name."[]".
	#						'" value="'.$input_param['option'][$k]['value'].'" />'.
	#						$input_param['option'][$k]['value']."\r\n</label></li>\r\n";
	#					}
	#					$HTML .= '</ul>	<!-- Close class="s_checklist" -->';
	*/
				}

					case "sendmessageto": {	/* function form_analyze_single_input */
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								trim($input_param['required'][0]['value'])!="" && !isset($GETPOSTvars[$name])) {
							/* user did NOT enter an email address*/
							$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
							$user_input[$name]['status'] = FALSE;
						} Else {

							SWITCH ($input_param['rendermode'][0]['value']) {
								case 0: /* ComboBox*/
								$user_input[$name]['value'] =  $GETPOSTvars[$name];
								If (isset($input_param['required'])) {
									If (isset($GETPOSTvars[$name]) && $GETPOSTvars[$name] == 0 ) {
										$user_input[$name]['status'] =  FALSE;
										$user_input[$name]['status'] = FALSE;
										$user_input[$name]['warningmsg'] = $input_param['required'][0]['value'];
									} Else {
										$user_input[$name]['status'] =  TRUE;
										$user_input[$name]['status'] = TRUE;
									}
								} Else {
								}
								break;

								case 1: /* RadioBox*/

									$user_input[$name]['status'] =  TRUE;
									$user_input[$name]['status'] = TRUE;
									If (isset($GETPOSTvars[$name])) {
										$user_input[$name]['value'] =  $GETPOSTvars[$name];
										$user_input[$name]['status'] =  TRUE;
										$user_input[$name]['status'] = TRUE;
									} Else {
										$user_input[$name]['status'] =  FALSE;
										$user_input[$name]['status'] = FALSE;

									}
								break;

								case 2: /* CheckBox*/
								break;
							}
						}
					}
					break;

					case "file":{	/* form_analyze_single_input()*/

	        	if (strpos ($user_input[$name]['value'],$this -> formpara['UserID']) > 0) {
	        	    $check = explode("|",$user_input[$name]['value']);
	        	   /* print_r($this -> formpara['UserID']);*/
	        	   /* print_r($user_input);*/
	        	    $user_input[$name]['showfileinfo'] = True;
	        	    $user_input[$name]['value'] = $check[1];
	        	    $user_input[$name]['filesizemsg'] = $check[2];
	        	    if ($check[3] != "")
	        	        $user_input[$name]['thumbnailpath'] = $check[3];
	        	} else {
	 						$user_input[$name]['showfileinfo'] = FALSE;
							/* = flag shows to render the input field, not the info on uploaded files*/
							/* First, we analyze if a valid file was uploaded*/
							If ($user_input[$name]['error'] == UPLOAD_ERR_OK) {	/* If there is no error, the file uploaded with success. */
								$validfile = TRUE;
								/* still the file could be unvalid due to an unvalid file extension or an unvalid size */

								$extensions = explode(";",$input_param['extension'][0]['value']); /* list of allowed extensions, separated by colons */
								$uploaded_extension = form_file_extension($user_input[$name]['dstfile']);
								$extension_allowed = FALSE;
								foreach($extensions as $key => $value) {
									If (strtolower($uploaded_extension) == strtolower($value)) $extension_allowed = TRUE;
								}
								If (!$extension_allowed) {
									$user_input[$name]['warningmsg'] .= " <br />".str_replace('{{fileext}}',$uploaded_extension,$GLOBALS['FormError']['exterror']);
									$validfile = FALSE;
								}
								If ($user_input[$name]['size'] > $input_param['maxsize'][0]['value']) {
									$validfile = FALSE;
								}
								if (strpos (" ".$user_input[$name]['value'],".php") > 0) {
									$user_input[$name]['warningmsg'] .= "<br />".$GLOBALS['FormError']['phphack'];
									$validfile = FALSE;
								}

							} Else {
								/* Here, NO file was uploaded */
									$validfile = FALSE;
							}

							/* Now we need to distinguish if a file upload was requested or not */
							If ($validfile) {
								$user_input[$name]['showfileinfo'] = TRUE;
								$user_input[$name]['status'] = TRUE;
								$user_input['status'] = TRUE;
								$user_input[$name]['warningmsg'] = "";

							} Else {
								/* Let's now investigate if a file upload was required */
									If (isset($input_param['required']) &&
											isset($input_param['required'][0]) &&
											isset($input_param['required'][0]['value']) &&
											$input_param['required'][0]['value']!="") {
									/* Here: An Upload was requested but no valid file was uploaded ==> another rendering round is required */
									$user_input[$name]['status'] = FALSE;
									$user_input['status'] = FALSE;
									$user_input[$name]['warningmsg'] = $input_param['required'][0]['value']; /* copy the warning message for this required input field*/

									/* Povide a more detailed warning message about a failed upload */
									if (strpos (" ".$user_input[$name]['value'],".php") > 0) {
										$user_input[$name]['warningmsg'] .= "<br />".$GLOBALS['FormError']['phphack'];
									}
									If ($user_input[$name]['size'] > $input_param['maxsize'][0]['value']) {
										$user_input[$name]['warningmsg'] .= "<br />".$GLOBALS['FormError']['sizeerror'];
									}
									If ($user_input[$name]['error']==UPLOAD_ERR_INI_SIZE) {
										$user_input[$name]['warningmsg'] .= "<br />".
												"<br />".$GLOBALS['FormError']['UPLOAD_ERR_INI_SIZE'];
									} Else If ($user_input[$name]['error']==UPLOAD_ERR_FORM_SIZE){
										$user_input[$name]['warningmsg'] .= $GLOBALS['FormError']['UPLOAD_ERR_FORM_SIZE'];

									} Else If ($user_input[$name]['error']==UPLOAD_ERR_PARTIAL) {
										$user_input[$name]['warningmsg'] .= $GLOBALS['FormError']['UPLOAD_ERR_PARTIAL'];

									} Else If ($user_input[$name]['error']==UPLOAD_ERR_NO_FILE) {
										$user_input[$name]['warningmsg'] .= $GLOBALS['FormError']['UPLOAD_ERR_NO_FILE'];

									} Else If ($user_input[$name]['error']==UPLOAD_ERR_NO_TMP_DIR) {
										$user_input[$name]['warningmsg'] .= $GLOBALS['FormError']['UPLOAD_ERR_NO_TMP_DIR'];

									} Else If ($user_input[$name]['error']==UPLOAD_ERR_CANT_WRITE) {
										$user_input[$name]['warningmsg'] .= $GLOBALS['FormError']['UPLOAD_ERR_CANT_WRITE'];
									}
									$user_input[$name]['showfileinfo'] = FALSE;

								} Else {
									/* Here: An Upload was NOT requested AND no valid file was uploaded ==> another rendering round is NOT required at least NOT for this item*/
									If ($user_input[$name]['size'] > $input_param['maxsize'][0]['value']) {
										If ($user_input[$name]['warningmsg']=="") {
											$user_input[$name]['warningmsg'] = $input_param['sizeerror'][0]['value']."<br />(max. ".$input_param['maxsize'][0]['value']." Bytes)";
										} Else {
											$user_input[$name]['warningmsg'] .= "<br />".$input_param['sizeerror'][0]['value']."<br />(max. ".$input_param['maxsize'][0]['value']." Bytes)";
										}
									}
									$user_input[$name]['status'] = TRUE;
									$user_input['status'] = TRUE;
									$user_input[$name]['showfileinfo'] = FALSE;
								}
							}

							/* In case that another item requires rendering we provide some informations on the uploaded file
							 * instead of showing again a file upload input field
							 */
							If ($user_input[$name]['status']) {
								$filesize = " &nbsp; &nbsp; &nbsp;[0 Bytes]";
								If ($user_input[$name]['size'] < 1024) {
									$filesize = " &nbsp;[".$user_input[$name]['size']." Bytes]";
								} Else If ($user_input[$name]['size'] < 1024*1024) {
									$filesize = round($user_input[$name]['size']/1024, 2);
									$filesize = " &nbsp; &nbsp; &nbsp;[".$filesize." kByte]";
								} Else {
									$filesize = round($user_input[$name]['size']/1024/1024, 2);
									$filesize = " &nbsp; &nbsp; &nbsp;[".$filesize." MBytes]";
								}
								$user_input[$name]['filesizemsg'] = $filesize;
							}
	          }
					}
					break;

					default:
					break;
				}
			} Else {
				$user_input['status'] = FALSE;
				$user_input[$name]['warningmsg'] = __FILE__.'<br />'.__LINE__.' Unknown error!';
			}
			If (trim($user_input[$name]['warningmsg']) != '') $this -> AddWarningmessage($name,$user_input[$name]['warningmsg']);
		} Else {/* End of If (isset($input_param['label']) && */
			/* process "sendbutton":*/
			If (isset($GETPOSTvars[$name])) {
				$user_input[$name]['value'] = $GETPOSTvars[$name];
				$user_input['status'] = TRUE;#
			} Else {
				/* process type="hidden" */
			}
		}
	/* Input errors are returned in detail in array $user_input*/
		$user_input['status'] &= $user_input[$name]['status'];
		$VCARD_values[$name]= $user_input[$name]['value'];
		return array($user_input,$VCARD_values);
	}

	private function form_analyze_input($GETPOSTvars,		/* received POST and/or GET data*/
												 							$fieldset,			/* array with XML specification for rendering the form*/
	                            				$VCARD_values){	/* O: array with received user input indexed by  form var names*/

	/* analyze input data inside current fieldset and compare against requirements*/
		$user_fieldset['status'] = TRUE;
		If (isset($fieldset['inputgroup'])) {
			/* $fieldset contains a number of input groups*/
			for ($ig = 0; $ig < count($fieldset['inputgroup']); $ig++) {
					/* Each input group contains a number of input lines*/
				$user_fieldset['inputgroup'][$ig] = array();
				$nInpElements = count($fieldset['inputgroup'][$ig]['input']);
				$user_fieldset['inputgroup'][$ig]['status'] = TRUE;
				for ($ie=0; $ie < $nInpElements; $ie++) {
					$user_fieldset['inputgroup'][$ig]['input'][$ie] = array();
					$retarray = $this -> form_analyze_single_input($GETPOSTvars,															/* received POST and/or GET data*/
																				                 $fieldset['inputgroup'][$ig]['input'][$ie],/* I: XML specification of selected input line*/
																				                 $VCARD_values);														/* O: array with received user input indexed by  form var names*/

					$status = $retarray[0]['status'];
					$user_fieldset['inputgroup'][$ig]['input'][$ie] = $retarray[0];
					$VCARD_values = $retarray[1];

					$user_fieldset['inputgroup'][$ig]['status'] &= $status;
				}
				/* The status of the fieldset can be TRUE only if the status of all input groups is TRUE:*/
				$user_fieldset['status'] = $user_fieldset['status'] &= $user_fieldset['inputgroup'][$ig]['status'];
			}
		}
	/* Input errors are returned in detail in array $user_fieldset:*/
		return array($user_fieldset, $VCARD_values);
	}

	public function form_Analyze_GETPOST_data($GETPOSTvars,		/* form data entered by user*/
																		        $user_input,		/* Pointer to the array which takes up all analyzed input data and some additional flags*/
																		        $VCARD_values) {/* O: array with received user input indexed by  form var names*/
		$status = TRUE; /*default: TRUE means, all required input data are entered and correct -> don't render the form again*/
		/* Go through the input list*/
		$nTABs = count($this -> formXMLdata['page'][0]['tab']);
		$user_input['page'][0]['tab'] = array();
		for ($it = 0; $it < $nTABs; $it++) {	/* Loop over all tabs:*/
			$user_input['page'][0]['tab'][$it] = array();
			$user_input['page'][0]['tab'][$it]['status'] = TRUE;
			/* Analyze input data combined in different fieldsets:*/
			$user_input['page'][0]['tab'][$it]['fieldset'] = array();
			for ($fs=0; $fs < count($this -> formXMLdata['page'][0]['tab'][$it]['fieldset']); $fs++) {
				$user_input['page'][0]['tab'][$it]['fieldset'][$fs] = array();
				If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value']!="") {
					$user_input ['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'] =
					$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'];
				}

				/* analyze input data inside current fieldset and compare against requirements*/
				$retarray =
				$this -> form_analyze_input(
											$GETPOSTvars,																									/* received POST and/or GET data*/
											$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs], /* array with XML specification for rendering the form*/
	                    $VCARD_values);																								/* O: array with received user input indexed by  form var names*/

				$user_input ['page'][0]['tab'][$it]['fieldset'][$fs] = $retarray[0];
				$VCARD_values	= $retarray[1];
				/* The status flag for the current tab is TRUE only if all fieldset status flags are TRUE:*/
				$user_input['page'][0]['tab'][$it]['status'] = $user_input['page'][0]['tab'][$it]['status']
																												 & $user_input['page'][0]['tab'][$it]['fieldset'][$fs]['status'];
			}
			$status &= $user_input['page'][0]['tab'][$it]['status'];/* compile over all status*/
		}
		/* Investigate the lure offer:*/
			$lurevalue = $this -> formpara['lurevalue'];
			If (strpos($lurevalue,"@")===FALSE) $lurevalue.= "@";
			If (defined('I_am_Online')) {
				$lurevalue.= $_SERVER['SERVER_NAME'];
			}
			$name = $this -> formpara['lurename'];
			If ($GETPOSTvars[$name]!=$lurevalue) {
				/* The invisible default value was manipulated*/
				die("invalid input value");
			}

	/* Input errors are returned in detail in array $user_input and a global success status is returned by the return status*/
		return array($status, $user_input, $VCARD_values);
	}

	private function form_render_single_input($input_param,$user_input) {
		$name = $input_param['name'][0]['value'];
		$HTML = '';
		If ($input_param['type'][0]['value']=="captcha") {
			If (!isset($input_param['required'][0]['value'])) {
				$input_param['required'][0]['value'] = "Eingabe ist wegen des Schutzes vor Spammern notwendig";
			}
		}
		$requiredmarker="";
		$requiredclass='';
			$requiredstr = '';
		If (isset($input_param['required']) &&
				isset($input_param['required'][0]) &&
				isset($input_param['required'][0]['value']) &&
		 		trim($input_param['required'][0]['value'])!="") {
			$requiredclass='class="required"';
			$requiredstr = ' required';/* HTML5 extension */;
			If (isset($this -> formpara['requiredmarker'])) $requiredmarker=" ".$this -> formpara['requiredmarker'];
		}
		$name = $input_param['name'][0]['value'];
		$warningitem= '';
		$warningclass = '';
		/* See if we should output a warning message*/
		If (isset($user_input[$name]['warningmsg'])) {
			If (trim($user_input[$name]['warningmsg'])!="") {
				$warningclass = ' class="error"';
				$warningitem = ' error';
			}
		}
		/* See if this input line has also a comment on top:*/
		$inpcomment	= '';
		$inputmsg = '';
		If (isset($input_param['comment']) &&
				isset($input_param['comment'][0]) &&
				isset($input_param['comment'][0]['value'])  &&
				trim($input_param['comment'][0]['value']) != "") {
					$inputmsg = $input_param['comment'][0]['value'];
		}
		If ($inputmsg != '') {
			$inpcomment	= '	<div class="inpcomment">'.PHP_EOL.
										'		'.$inputmsg.PHP_EOL.
										'	</div><!-- Close  class="inpcomment" -->'.PHP_EOL;
		}
		If (isset($input_param['label']) &&
				isset($input_param['label'][0]) &&
				isset($input_param['label'][0]['value'])) {
			$label = $input_param['label'][0]['value'];
			If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;
		} Else {
			$label = '';
		}


		$value="";
		If (isset($input_param['defaultvalue']) &&
				isset($input_param['defaultvalue'][0]) &&
				isset($input_param['defaultvalue'][0]['value']))
		$value = $input_param['defaultvalue'][0]['value'];
		/* If user has entered a value take this on instead*/
		If (isset($user_input[$name]) &&
				isset($user_input[$name]['value']))
			$value = $user_input[$name]['value'];

		SWITCH (trim($input_param['type'][0]['value'])) {

			case "countryselect":	{	/*function form_render_single_input*/
				$HTML =
					$this -> GriddyRenderCountryselect ($label,
																							$name,
																							$input_param,
																							$user_input,
																							$inpcomment,                      		/* 'Zusatztext' 						*/
																							$warningclass);
			break;
			}

			case 'comment': {/*function form_render_single_input*/
				$HTML =
					$this -> GriddyRenderComment ($input_param['label'][0]['value'],
																				$input_param['defaultvalue'][0]['value'],false);
			break;
			}

			case "confirmation": {/*function form_render_single_input*/
				$HTML = '<div class="legaltext">'.$input_param['AGBText'][0]['value'].'</div>	<!-- Close  class="legaltext" -->'.PHP_EOL;
				$HTML .= '	<div class="radioright">'.PHP_EOL;
				$HTML .= '		<label class="confirm'.$requiredclass.'" for="'.$name.'_'.$this -> formpara['FORMsID'].'ok">'.PHP_EOL;
				If (isset($input_param['required']) &&
						isset($input_param['required'][0]['value'])) {
					$HTML .= '			<input tabindex="'.$this -> TabIndex.'" class="radio" type="radio" name="'.$name.'" id="'.$name.'_'.$this -> formpara['FORMsID'].'ok" value="confirmed"'.$requiredstr.PHP_EOL.
							 ' 			data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
				} Else {
					$HTML .= '			<input tabindex="'.$this -> TabIndex.'" class="radio" type="radio" name="'.$name.'" id="'.$name.'_'.$this -> formpara['FORMsID'].'ok" value="confirmed"'.$requiredstr.'>'.PHP_EOL;
				}
				$HTML .= '			'.$input_param['confirmok'][0]['value']."</label>\r\n";
				$HTML .= '	</div>	<!-- close  class="radioright"	-->'.PHP_EOL;
				$HTML .= '	<div class="radioright">'.PHP_EOL;
				$HTML .= '		<label class="confirm'.$requiredclass.'" for="'.$name.'_'.$this -> formpara['FORMsID'].'notok">'.PHP_EOL;
			If (isset($input_param['required']) &&
					isset($input_param['required'][0]['value'])) {
				$HTML .= '			<input tabindex="'.$this -> TabIndex.'" class="radio" type="radio" name="'.$name.'" checked="checked" id="'.$name.'_'.$this -> formpara['FORMsID'].'notok" value="confirmed"'.$requiredstr.
						 ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
			} Else {
				$HTML .= '			<input tabindex="'.$this -> TabIndex.'" class="radio" type="radio" name="'.$name.'" checked="checked" id="'.$name.'_'.$this -> formpara['FORMsID'].'notok" value="confirmed"'.$requiredstr.'>'.PHP_EOL;
			}
				$HTML .= '			'.$input_param['confirmnotok'][0]['value']."</label>".PHP_EOL;
				$HTML .= '	</div>	<!-- close  class="radioright"	-->'.PHP_EOL;
			break;
			}

			case "password": {/*function form_render_single_input*/
				$HTML =
				$this -> GriddyRenderInputTEXT ($label,
																				$warningclass,
																				$input_param['type'][0]['value'],
																				$this -> formpara['FORMsID'],
																				$name,
																				$input_param,
																				FrmData::PrepareValue ($value),
																				$inpcomment,
																				$requiredstr);
			break;
			}

			case "hidden": {/*function form_render_single_input*/
				$HTML = '<input type="hidden" value="'.FrmData::PrepareValue ($value).'"'." />".PHP_EOL;
			break;
			}

			case "email":
			case "text": {/*function form_render_single_input*/
				$HTML =
				$this -> GriddyRenderInputTEXT ($label,
																				$warningclass,
																				$input_param['type'][0]['value'],
																				$this -> formpara['FORMsID'],
																				$name,
																				$input_param,
																				FrmData::PrepareValue ($value),
																				$inpcomment,			/*  equals "Zusatztext"										 */
																				$requiredstr);

			break;
			}

			case "textarea": {/*function form_render_single_input*/
				$readonly="";
				If (isset($input_param['readonly']) &&
						isset($input_param['readonly'][0]) &&
						isset($input_param['readonly'][0]['value']))
				$readonly = $input_param['readonly'][0]['value'];
				$cols = 60;
				If (isset($input_param['cols']) &&
						isset($input_param['cols'][0]) &&
						isset($input_param['cols'][0]['value']))
				$cols = $input_param['cols'][0]['value'];
				$rows = 4;
				If (isset($input_param['rows']) && isset($input_param['rows'][0]) &&
						isset($input_param['rows'][0]['value']))
				$rows = $input_param['rows'][0]['value'];
				$label = $input_param['label'][0]['value'];
				If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;
				$HTML =
					$this -> GriddyRenderTextArea($label,
																				$warningclass,
																				$name.'_'.$this -> formpara['FORMsID'],	/* id */
																				$rows,
																				$name,
																				$input_param,
																				$inpcomment,
																				$readonly,
																				$requiredstr,
																				FrmData::PrepareValue ($value));				/* content */
			break;
			}

			case "spamquestion": {/*function form_render_single_input*/
				$HTML .= $label;
				$HTML .= '<ul class="s_checklist" style="height:'.$input_param['boxheight'][0]['value'].';">'.PHP_EOL;
				for ($k=0; $k < count($input_param['answer'][0]['option']); $k++) {
					$checked = '';
					If (isset($input_param['answer']) &&
							isset($input_param['answer'][0]) &&
							isset($input_param['answer'][0]['option']) &&
							isset($input_param['answer'][0]['option'][$k]) &&
							isset($input_param['answer'][0]['option'][$k]['checked'])) $checked = ' checked="checked"';
					$HTML .= '<li><label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'."\r\n".
					'<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$this -> formpara['FORMsID'].
					'" type="radio"'.$checked.
					' name="'.$name.
					'" value="'.FrmData::PrepareValue ($input_param['answer'][0]['option'][$k]['radiovalue'][0]['value']).$requiredstr;
					If (isset($input_param['required']) &&
							isset($input_param['required'][0]['value'])) {
						$HTML .= PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
					} Else {
						$HTML .= '>'.PHP_EOL;
					}
					$input_param['answer'][0]['option'][$k]['radiolabel'][0]['value']."\r\n</label></li>\r\n";
				}
				$HTML .= '</ul>	<!-- Close class="s_checklist" -->';
			break;
			}

			case "radio": {/*function form_render_single_input*/
				$label = $input_param['label'][0]['value'];
				If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;
				$HTML = $this -> GriddyRenderRadios($label,
																						$this -> formpara['FORMsID'],
																						$this -> formpara['RadioMode'],
																						$name,				/* server variable								*/
																						$input_param,
																						$input_param['option'],
																						$user_input[$name]['option'],
																						$inpcomment,
																						$requiredstr);
				break;
			}

			case "sendmessageto":	{/*function form_render_single_input*/
				$label = $input_param['label'][0]['value'];
				If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;

				SWITCH ($input_param['rendermode'][0]['value']) {
					case 0: {/* "send message to" as ComboBox/SelectBox*/
						$SelectBox = '';
						If (trim($inpcomment)!= '') {
							$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);/* TRUE means, previous content is cleared */
							$this -> FormGriddy -> AddtoXY(1,0,$inpcomment,TRUE);
							$this -> FormGriddy -> DecoClass[1] = '';/* 'margin0';*/
							$SelectBox = $this -> FormGriddy -> GetHtml();
							$this -> FormGriddy -> DecoClass[1] = '';
						}
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value'])) {
							$closetag = PHP_EOL.' data-msg-required="'.$input_param['required'][0]['value'].'" required>'.PHP_EOL;
						} Else {
							$closetag = '>'.PHP_EOL;
						}


						If (isset($user_input[$name]['warningmsg']) &&
							$user_input[$name]['warningmsg'] != "") {
							$retval = '<select tabindex="'.$this -> TabIndex.'"  id="'.$name.'_'.$this -> formpara['FORMsID'].'" name="'.$name.'" '.$warningclass.$closetag;
						} Else {
							$retval = '<select tabindex="'.$this -> TabIndex.'"  id="'.$name.'_'.$this -> formpara['FORMsID'].'" name="'.$name.'"'.$closetag;
						}

						for ($k=0; $k < count($input_param['index']); $k++) {
							$selected = '';
							If (isset($user_input[$name]) && isset($user_input[$name]['value'])) {/* entered by user*/
								If ($user_input[$name]['value'] > 0 &&
										$input_param['index'][$k]['value'] == $user_input[$name]['value']) {
									$selected = ' selected="selected" ';
								}
							} ElseIf ($input_param['defaultvalue'][0]['value'] == $input_param['index'][$k]['value']) {
									$selected = ' selected="selected" ';
							}
							If ($k > 0) {
								$retval .= '<option value="'.$input_param['index'][$k]['value'].'" '.$selected.'>';
							} else {
								$retval .= '<option value="" '.$selected.'>';
							}
							$retval .= $this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname'].
												 '</option>'.PHP_EOL;
						}
						$retval .= '</select>'.PHP_EOL;
						If (trim($label) == '') {
							$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
						} Else {
							$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
						}
						$this -> FormGriddy -> AddtoXY(1,0,$retval,TRUE);


						$SelectBox .= $this -> FormGriddy -> GetHtml();
						$HTML .= $SelectBox;
					break;
					}
					case 1: {/* "send message to" as RadioBox */
						If (isset($input_param['required']) &&
								isset($input_param['required'][0]) &&
								isset($input_param['required'][0]['value']) &&
								trim($input_param['required'][0]['value'])!="") {
							$k0 = 1;
						} Else {
							$k0 = 0;
						}

						$RightContent = '';
						for ($k=$k0; $k < count($input_param['index']); $k++) {
							$checked = '';
							If (isset($user_input[$name]) && isset($user_input[$name]['value'])) {/* entered by user*/
								If ($input_param['index'][$k]['value'] == $user_input[$name]['value']) {
									$checked = ' checked="checked"';
								}
							} ElseIf ($input_param['defaultvalue'][0]['value'] == $input_param['index'][$k]['value']) {
									$checked = ' checked="checked"';
							}
							If ($this -> formpara['RadioMode'] == 'fancy') {
								$RightContent .=
								'<p class="fancy">'.PHP_EOL.
								'	<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$this -> formpara['FORMsID'].
								'" type="radio"'.$checked.
								' name="'.$name.'"'.
								' value="'.FrmData::PrepareValue ($input_param['index'][$k]['value']).$requiredstr.PHP_EOL;
								If (isset($input_param['required']) &&
										isset($input_param['required'][0]['value'])) {
									$RightContent .= ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
								} Else {
									$RightContent .= '">'.PHP_EOL;
								}
								$RightContent .=
								'	<label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'.PHP_EOL.
								' 	'.FrmData::PrepareValue ($this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname']).PHP_EOL.
								'	</label>'.PHP_EOL.
								'</p>		<!-- Close  class="fancy" -->'.PHP_EOL;
							} else {
								$RightContent .=
								'<p class="standard">'.PHP_EOL.
								'	<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$FORMsID.
								'" type="radio"'.$checked.
								' name="'.$name.'"'.
								' value="'.FrmData::PrepareValue ($input_param['index'][$k]['value']).$requiredstr;
								If (isset($input_param['required']) &&
										isset($input_param['required'][0]['value'])) {
									$RightContent .= ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
								} Else {
									$RightContent .= '">'.PHP_EOL;
								}
								'	<label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'.PHP_EOL.
								' 	'.FrmData::PrepareValue ($this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname']).PHP_EOL.
								'	</label>'.PHP_EOL.
								'</p>		<!-- Close  class="standard" -->'.PHP_EOL;
							}
						}
						If (trim($label) == '') {
							$this -> FormGriddy -> AddtoXY(0,0,'',TRUE);
						} Else {
							$this -> FormGriddy -> AddtoXY(0,0,'<p><span class="vcenter">'.$label.'</span></p>',TRUE);
						}
						$this -> FormGriddy -> AddtoXY(1,0,$RightContent,TRUE);
						$HTML .= $this -> FormGriddy -> GetHtml();
					break;
					}
					case 2: {/* "Send message to" as CheckBox, 111 not implemented yet in SENTRA*/
						for ($k=0; $k < count($input_param['index']); $k++) {
							$HTML .= '<label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'."\r\n".
							'<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$this -> formpara['FORMsID'].
							'" type="checkbox'.
							'" name="'.$name."[]".
							'" value="'.$input_param['index'][$k]['value'].'"'.$requiredstr.PHP_EOL;
							If (isset($input_param['required']) &&
									isset($input_param['required'][0]['value'])) {
								$RightContent .= ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
							} Else {
								$RightContent .= '">'.PHP_EOL;
							}
							$RightContent .=
							'<b>'.PHP_EOL.
								FrmData::PrepareValue ($this -> formpara['emaillist'][ $input_param['index'][$k]['value'] ]['personsname']).PHP_EOL.
							'</b>'.PHP_EOL.'</label>'.PHP_EOL;
						}
					break;
					}
				}
				break;
			}

			case "selectbox":	{/* function form_render_single_input*/
				If (isset($user_input[$name]['warningmsg']) &&
					$user_input[$name]['warningmsg'] != "") {
						$warningclass=  'class="warning"';
				} Else {
					$warningclass=  '';
				}
				If (!isset($user_input['optgroup']))
				$user_input['optgroup'] = array();
				If(!isset($user_input[$name]['selectionchosen'])) $user_input[$name]['selectionchosen'] = FALSE;
				$label = $input_param['label'][0]['value'];
				If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;
				$HTML =
				$this -> GriddyRenderSelectBox($label,												/* label 										*/
																				$warningclass,                /* 'class="warning"' or ''	*/
																				$this -> formpara['FORMsID'], /* ID 											*/
																				$name,                        /* server variable					*/
																				$input_param,
																				$user_input,
																				$input_param['optgroup'],     /* selectbox optionsgroup 	*/
																				$inpcomment,                  /* 'Zusatztext' 						*/
																				$requiredstr);                /* 'required' or ''					*/
				break;
			}
			/* Single checkbox */
			case "s_checkbox":{/*function form_render_single_input*/
					$checked = '';
					If (isset($input_param['option'][0]['checked'])) $checked = ' checked="checked"';
					/* Default values may have been changed by user inputs:*/
					If (isset($user_input['option'][0]['checked'])) {
						If ($user_input['option'][0]['checked']) {
							$checked = ' checked="checked"';
						} else {
							$checked = '';
						}
					}
				$optionsvalue = FrmData::PrepareValue($input_param['option'][0]['optionvalue'][0]['value']);
				$label = $input_param['label'][0]['value'];
				If ($input_param['label'][0]['value']!='') $label .= $requiredmarker;
				$HTML =
				$this -> GriddyRenderS_CheckBox($label,	/* label */
																				$warningitem,                     	/* ' error' or ''					*/
																				$this -> formpara['FORMsID'],     	/* ID 											*/
																				$this -> formpara['CheckMode'],    	/* =="standard" or "fancy"  */
																				$name,                            	/* server variable					*/
																				$input_param,
																				$optionsvalue,                     	/* checkbox value 					*/
																				$inpcomment,                      	/* 'Zusatztext' 						*/
																				$requiredstr,                     	/* 'required' or ''					*/
																				$checked);                        	/* ' checked="checked"'or ''*/
				break;
			}

			/* list of checkboxes */
			case "checkbox":{		/*function form_render_single_input*/
				$HTML .=  '<ul class="s_checklist" style="height:'.$input_param['boxheight'][0]['value'].';">'.PHP_EOL;
				for ($k=0; $k < count($input_param['option']); $k++) {
					$checked = '';
					If (isset($input_param['option'][$k]['checked'])) $checked = ' checked="checked"';
					$HTML .=
					'	<li>'.PHP_EOL.
					'		<label for="'.$name.$k.'_'.$this -> formpara['FORMsID'].'">'.PHP_EOL.
					'			<input tabindex="'.$this -> TabIndex.'" id="'.$name.$k.'_'.$this -> formpara['FORMsID'].
					'" type="checkbox"'.$checked.
					' name="'.$name.'[]'.
					'" value="'.FrmData::PrepareValue ($input_param['option'][$k]['optionvalue'][0]['value']).'"'.$requiredstr.PHP_EOL;
					If (isset($input_param['required']) &&
							isset($input_param['required'][0]['value'])) {
						$HTML .= ' data-msg-required="'.$input_param['required'][0]['value'].'">'.PHP_EOL;
					} Else {
						$HTML .= '">'.PHP_EOL;
					}
					$HTML .= '				<b>'.PHP_EOL.
					'					'.FrmData::PrepareValue ($input_param['option'][$k]['optionvalue'][0]['value']).PHP_EOL.
					'				</b>'.PHP_EOL.
					'		</label>'.PHP_EOL.
					'	</li>'.PHP_EOL;
				}
				$HTML .= '</ul>	<!-- Close class="s_checklist" -->';

				break;
			}

			case "file":{	/*function form_render_single_input*/
				$HTML=$this -> GriddyRenderFileUpload($label,						/* $label 													*/
																							$name,						/* $input_param['name'][0]['value'] */
																							$input_param,
																							$user_input,
																							$inpcomment,      /* 'Zusatztext' 										*/
																							$requiredstr,
																							$warningclass);		/* $warningclass,   								*/
				break;
			}

			case "captcha": {/*function form_render_single_input*/
				$HTML= $this -> GriddyRenderCaptcha($label,         /* $label 													*/
																						$name,          /* $input_param['name'][0]['value'] */
																						$input_param,
																						$user_input,
																						$inpcomment,    /* 'Zusatztext' 										*/
																						$requiredstr,
																						$warningclass); /* $warningclass,   								*/
				break;
			}

			case "sendbutton": {/*function form_render_single_input*/
				$HTML= $this -> GriddyRenderSendBtn('',
																						$this -> formpara['buttontext'],
																						$this -> formpara['buttonaligned'],
																						$input_param['name'][0]['value'],
																						$this -> formpara['btnStyle'],
																						$this -> formpara['btnSize']);
			break;
			}

			default:
				$HTML .= "<br> form_render_single_input(): ...kein Einsprung gefunden!";
			break;
		}
		return $HTML;
	}
	/* render all input fields of the current fieldset*/
	private function form_render_fieldset($fieldset,		/* I: parameter of fieldset input elements to be rendered*/
																				$user_input) {/* I: values of user input in case something was sent already*/
		$HTML = '';
		/* a fieldset may contain some specific comments:*/
		If (isset($fieldset['comment'])) {
			$HTML .= '<div class="comment"><p>'.PHP_EOL;
			$HTML .= $fieldset['comment'][0]['value'];
			$HTML .= '</p></div><!-- Close class="comment" -->'.PHP_EOL;
		}
		/* $fieldset contains a number of input groups*/
		If (isset($fieldset['inputgroup'])) {
			for ($ig = 0; $ig < count($fieldset['inputgroup']); $ig++) {
				/* Each input group contains a number of input lines*/
				$nInpElements = count($fieldset['inputgroup'][$ig]['input']);
				$HTML .= '<div class="fieldsetelements">'.PHP_EOL;
				If (isset($fieldset['inputgroup'][$ig]['comment'])) {
					$HTML .= '<div class="comment"><p>';
					$HTML .= $fieldset['inputgroup'][$ig]['comment'][0]['value'];
					$HTML .= '</p></div><!-- Close class="comment" -->'.PHP_EOL;
				}
				if (isset($fieldset['inputgroup']) &&
						isset($fieldset['inputgroup'][$ig]) &&
						isset($fieldset['inputgroup'][$ig]['style']) &&
						isset($fieldset['inputgroup'][$ig]['style'][0]) &&
						isset($fieldset['inputgroup'][$ig]['style'][0]['value'])) {
						If ($nInpElements > 1) {
							$divtag =  '<div class="input'.$nInpElements.'" style="'.$fieldset['inputgroup'][$ig]['style'][0]['value'].'">'.PHP_EOL;
						} Else {
							$divtag = '';
							$divtagclosed = '';
						}
				} Else {
					If ($nInpElements > 1) {
						$divtag =  '<div class="input'.$nInpElements.'">'.PHP_EOL;
						$divtagclosed = PHP_EOL."</div>".'<!-- close <div class="input'.$nInpElements.'" -->'.PHP_EOL;
					} Else {
						$divtag = '';
						$divtagclosed = '';
					}
				}
				for ($ie=0; $ie < $nInpElements; $ie++) {	/* process 4 input elements per line at most*/
					$HTML .= $divtag;
					$HTML .= $this -> form_render_single_input($fieldset['inputgroup'][$ig]['input'][$ie],
																										 $user_input['inputgroup'][$ig]['input'][$ie]);
					$HTML .= $divtagclosed;
				}
				$HTML .= '</div>	<!-- Close class="fieldsetelements" -->'.PHP_EOL;
			}
		} Else {
		}
		return $HTML;
	}
	public function form_rendering($user_input) {
		if (!defined('I_am_Online') && !defined('SENTRA_DESIGNER')) {
			global $wb;
		}
		/* Rendering the form*/
		$this -> FieldSets  = '';		/* Send form's ID which is recognised by the server script:*/
		$this -> FieldSets .= '<input type="hidden" name="id" value="'.$this -> formpara['FORMsID'].'" />'.PHP_EOL;
		$this -> FieldSets .= '<input type="hidden" name="MyUserID_'.$this -> formpara['FORMsID'].'" value="'.$this -> formpara['UserID'].'" />'.PHP_EOL; /* ID of visitor */

		/* Offer a lure for spam bots*/
		$this -> lurevalue = $this -> formpara['lurevalue'];
		If (strpos($this -> lurevalue,"@")===FALSE) $this -> lurevalue.= "@";
		If (defined('I_am_Online')) {
			$this -> lurevalue.= $_SERVER['SERVER_NAME'];
		}
		$this -> FieldSets .= '<input class="imail" type="text" name="'.$this -> formpara['lurename'].'" value="'.$this -> lurevalue.'" />'.PHP_EOL;

		/* No we are ready to render all input fields*/
		$nTABs = count($this -> formXMLdata['page'][0]['tab']);
		If ($nTABs > 6) $nTABs = 6;

		/* First see if we have a multi tabform:*/
		If ($nTABs > 1) {
			require_once(SENTRA_SCRIPT_CORE."tabs.class.php");
			$formtab = new TabHandler("f_{{ID}}");

			/* 1. render the tabs including captions*/
			If(isset($user_input)) {
				for ($it=0; $it < $nTABs; $it++) {
					If (!$user_input['page'][0]['tab'][$it]['status']) {
						$formtab ->Add($it,$this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]['value'],"warning");
					} Else {
						$formtab ->Add($it,$this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]['value']);
					}
		  	}
			} Else {
				for ($it=0; $it < $nTABs; $it++) {
						$formtab ->Add($it,$this -> formXMLdata['page'][0]['tab'][$it]['caption'][0]['value']);
		  	}
			}
			$this -> FieldSets .= $formtab ->GetListCode();
		}

		$hiddenfieldsetlabelclass="fsleft";
		$fieldsetlabelclass='class="icenter fsleft"';
		If ($this -> formpara['LabelPosition'] == 'top') {
			$fieldsetlabelclass = 'class="icenter '.$this -> formpara['LabelPosition'].'"';
			$hiddenfieldsetlabelclass = $this -> formpara['LabelPosition'];
		} ElseIf ($this -> formpara['LabelPosition'] == 'placeholder') {
			$fieldsetlabelclass = 'class="icenter inside"';
			$hiddenfieldsetlabelclass = 'inside';
		} Else {
			$fieldsetlabelclass = 'class="icenter left"';
			$hiddenfieldsetlabelclass = 'left';
		}
		/* 2. Render tab contents*/
		for ($it=0; $it < $nTABs; $it++) {
			If ($it > 0) {
				$this -> FieldSets .= $formtab ->NewTabContent($it);
			}
			/* start processing with potential fieldsets:*/
			for ($fs=0; $fs < count($this -> formXMLdata['page'][0]['tab'][$it]['fieldset']); $fs++) {
				If (!isset($user_input['page'][0]['tab'][$it]['fieldset'][$fs])) {
					$user_input = array();
					$user_input['page'][0]['tab'][$it]['fieldset'][$fs] = array();
					If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value']!="") {
							$user_input['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'] = $this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'];
					} Else {
							$user_input['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'] = "";
					}
					$user_input['page'][0]['tab'][$it]['fieldset'][$fs] = $this -> form_prefill_fieldset_user_input($user_input['page'][0]['tab'][$it]['fieldset'][$fs],$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]);
				}
				$iconstyle='';
				$icon_in_fieldset = FALSE;
				If (isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'])) {
					If (isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]) &&
							isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src']) &&
							isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]) &&
							isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'])) {
						If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value']!="") {
							if (defined('I_am_Online')) {
								list($iconwidth,$iconheight) = getimagesize(SENTRA_HOME.'assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value']);
								If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="top") {
									$iconstyle=' style="padding-top: '.$iconheight.'px; background:url('.SENTRA_HOME.'assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} else If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="bottom") {
									$iconstyle=' style="padding-bottom: '.$iconheight.'px; background:url('.SENTRA_HOME.'assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} else {
									$iconstyle=' style="background:url('.SENTRA_HOME.'assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								}
							} Else if (defined('SENTRA_DESIGNER')) {
								/* Here: the Visual Template Designer is active */

								list($iconwidth,$iconheight) = getimagesize(FILLS.DIRECTORY_SEPARATOR.'Form/assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value']);
								If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="top") {
									$iconstyle=' style="padding-top: '.$iconheight.'px; background:url('.SENTRA_HOME.'assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} else If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="bottom") {
									$iconstyle=' style="padding-bottom: '.$iconheight.'px; background:url('.FILLS.DIRECTORY_SEPARATOR.'Form/assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} else {
									$iconstyle=' style="background:url('.FILLS.DIRECTORY_SEPARATOR.'Form/assets/images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								}

							} else {
								If (file_exists($wb->PluginImages.DIRECTORY_SEPARATOR.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'])) {
									list($iconwidth,$iconheight) = getimagesize($wb->PluginImages.DIRECTORY_SEPARATOR.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value']);
								} else {
									$iconheight = 0;
									print_r('not found: '.$wb->PluginImages.DIRECTORY_SEPARATOR.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value']);
								}
								If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="top") {
									$iconstyle=' style="padding-top: '.$iconheight.'px; background:url(./plugin_images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} else If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="bottom") {
									$iconstyle=' style="padding-bottom: '.$iconheight.'px; background:url(./plugin_images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								} Else {
									$iconstyle=' style="background:url(./plugin_images/'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['src'][0]['value'].') ';
								}
							}
							If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['repeat'][0]['value']!="") {
								$iconstyle.=$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['repeat'][0]['value'].' ';
								$icon_in_fieldset = FALSE;
								If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['repeat'][0]['value']=="repeat")
								$icon_in_fieldset = TRUE;
							}
							If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['xpos'][0]['value']=="left") {
								$iconstyle.='1% ';
							} ElseIf ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['xpos'][0]['value']=="center") {
								$iconstyle.='center ';
							} ElseIf ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['xpos'][0]['value']=="right") {
								$iconstyle.='99% ';
							}
							If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="bottom") {
								$iconstyle.='bottom;';
							} ElseIf ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="middle") {
								$iconstyle.='center;';
							} ElseIf ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'][0]['ypos'][0]['value']=="top") {
								$iconstyle.='top;';
							}
							$iconstyle.='"';
						}
					}
				}
				$fieldsetclose = '	<!-- Close '.$fieldsetlabelclass.' -->'.PHP_EOL;
				If ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value']!="") {
					If (isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'])) {
						If ($icon_in_fieldset) {
							$this -> FieldSets .= '<fieldset '.$fieldsetlabelclass.$iconstyle.">".PHP_EOL;
						} Else {
							$this -> FieldSets .= '<fieldset '.$fieldsetlabelclass.">".PHP_EOL;
						}
						$this -> FieldSets .= '<legend>'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'].'</legend>'.PHP_EOL;
						/* Add container with icon as background image AND container size== icon size */
						If ($icon_in_fieldset) {
							$this -> FieldSets .= '<div class="fsiconbg"></div>'.PHP_EOL;
						} Else {
							$this -> FieldSets .= '<div class="fsiconbg"'.$iconstyle.'>'.PHP_EOL;
						}
					} Else {
						$this -> FieldSets .= '<fieldset '.$fieldsetlabelclass.">".PHP_EOL;
						$this -> FieldSets .= '<legend>'.$this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['legend'][0]['value'].'</legend>'.PHP_EOL;
						$this -> FieldSets .= '<div class="fsiconbg"></div>'.PHP_EOL;
					}
				} Else {
					$this -> FieldSets .= '<fieldset class="hidden '.$hiddenfieldsetlabelclass.'">'.PHP_EOL;
					$this -> FieldSets .= '<div class="fsiconbg"></div>'.PHP_EOL;
					$fieldsetclose = '	<!-- Close class="hidden" -->'.PHP_EOL;
				}
				$this -> FieldSets .= $this -> form_render_fieldset ($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs],	/* pointer to input groups of current fieldset */
														 																		$user_input['page'][0]['tab'][$it]['fieldset'][$fs]						/* pointer to user_input array for received data of selected fieldset */
																															 );
					If (isset($this -> formXMLdata['page'][0]['tab'][$it]['fieldset'][$fs]['icon'])) {
						If (!$icon_in_fieldset) {
							$this -> FieldSets .= '</div><!--	Close class="fsiconbg" -->';
						}
					}
					$this -> FieldSets .= '</fieldset>'.$fieldsetclose.PHP_EOL;
			}
		}
		If ($nTABs > 1) {
			$this -> FieldSets .= $formtab ->CloseAll();
			$formtab ->Dispose();
		}
		if (!empty($GLOBALS['uploadedsrc'])) {
			$this -> FieldSets .= '<input type="hidden" name="uploadedsrc" value="'.implode("|", $GLOBALS['uploadedsrc']).'" />'.PHP_EOL;
			$this -> FieldSets .= '<input type="hidden" name="uploadeddest" value="'.implode("|", $GLOBALS['uploadeddest']).'" />'.PHP_EOL;
		}

		$formcentering = '';
		If ($this -> formpara['centering'] == '1') {
			$formcentering = ' icenter';
		}
		If (!defined ('SENTRA_DESIGNER')) {
			If (defined('I_am_Online')) {
				/* this script is running on the target server */
				require_once(SENTRA_HOME.'assets/sentra_scripts/pagemill.php');
			} Else {
				/* Here: SENTRA preview is active */
				require_once('../../common/pagemill.php');
			}
		}

		$pm = new PageMill();
		$pm -> SetVariable('formname'	, $this -> formpara['id']);
		$pm -> SetVariable('form_ID'	, $this -> formpara['id']);
		$pm -> SetVariable('formclass', $formcentering);
		If (defined('I_am_Online')) {
			/* We are online on target server */
			$pm -> SetVariable('ValidatePass'	, SENTRA_HOME.'assets/js/');
			$pm -> SetVariable('captchacheckPath'	, SENTRA_HOME.'assets/_captcha/');
		} Else {
			If (defined ('SENTRA_DESIGNER')) {
				/* The Visual Tempalte designer is running */
				$pm -> SetVariable('ValidatePass'	, './intern/');
				$pm -> SetVariable('captchacheckPath'	, './assets/_captcha/');
			} else {
				/* SENTRA preview */
				$pm -> SetVariable('ValidatePass'	, './intern/');
				$pm -> SetVariable('captchacheckPath'	, SENTRA_HOME.'assets/_captcha/');
			}
		}
		If (trim($this -> WarningText) != '') {
			$pm -> setCondition('ShowWarning' ,TRUE);
			$pm -> SetVariable('WarningText'	, $this -> WarningText);
		}

		$pm -> SetVariable('formenctype'	, $this -> formpara['enctype']);
		$pm -> SetVariable('formmethod'		, $this -> formpara['method']);
		$pm -> SetVariable('formaction'		, $this -> formpara['action'].$this -> formpara['uniqueID']);

		$pm -> SetVariable('fmwstyle'	, $this -> formpara['fmwstyle']);

		$pm -> SetVariable('FieldSets'	, $this -> FieldSets);
		$this -> RenderedForm = $pm->WriteText($this -> formpara['form_tpl']);
		unset($pm);
		return $this -> RenderedForm;
	}

	public function form_prefill_single_input($user_input,$input_param) {    /* results array for received data of selected input line */

		$name = $user_input['name'][0]['value'];
		$user_input[$name] = $input_param;
		/* Assume there is no user input; this may be modified during input analysis:*/
		$user_input[$name]['status'] = FALSE;
		$user_input[$name]['warningmsg'] = "";
		$user_input[$name]['value'] = "";
		$user_input[$name]['selectionchosen'] = FALSE;
		If (isset($input_param['defaultvalue']) && isset($input_param['defaultvalue'][0]['value']))
			$user_input[$name]['value'] = $input_param['defaultvalue'][0]['value'];
		return $user_input;
	}

	public function form_prefill_fieldset_user_input($user_input,$input_param) {		/* I: pointer to results array of current fieldset*/

		$retval = array();
		If (isset($user_input['inputgroup'])) {
			for ($ig = 0; $ig < count($user_input['inputgroup']); $ig++) {
				/* Each input group contains a number of input lines*/
				$nInpElements = count($user_input['inputgroup'][$ig]['input']);
				If ($nInpElements > 4) $nInpElements = 4;/* In style-form.css styles are defined for 4 input fields on one line at most */
				for ($ie=0; $ie < $nInpElements; $ie++) {
					$retval['inputgroup'][$ig]['input'][$ie] = $this -> form_prefill_single_input($user_input['inputgroup'][$ig]['input'][$ie],
																																												$input_param['inputgroup'][$ig]['input'][$ie]);   /* pointer to results array for received data of selected input line*/
				}
			}
			return $retval;		/* O: results array of current fieldset*/
		} Else {
			echo '<br /><br />'.__FILE__.'Line: '.__LINE__.'::'.PHP_EOL;
			echo '<p style="background:red;color:white;">'.PHP_EOL."$"."user_input['inputgroup'] NOT defined!!!".PHP_EOL.'</p>';
			return(FALSE);
		}
	}
}
?>