<?php
/*
 * \SentraDesigner\fills\Form\sentra-functions\formgriddy.class.php
 */

class FormGriddy {

	private $content = array(0 => array());
	private $gridCount = 2;
	private $gridCountmax = 12;
	private $exeDir = '';
	public	$split = array (0 => 6,1 => 6);
	public	$width = array (0 => 6,1 => 6);

	public	$Index = 0;
	public	$IndexY = 0;

	public	$Breaks = array();
	public	$BreakClasses = array('','');
	public	$BreakPoints = true;
	public	$ColPadding=array('0','0');
	public	$GridPadding = '2px';
	public	$GridMargin = '2px 0 0';
	public	$DecoClass = array();
	public	$BaseSelector = '';
	public	$MaxWidth = '100%';

	public function __construct ($split = array (),$maxCount = 12) {
		$this->exeDir = dirname(__FILE__).'/';
		If (defined('SCREEN_TN_MIN')) {
			/* here: VTD is running */
			$this->Breaks[] = SCREEN_SM_MIN;
			$this->Breaks[] = SCREEN_TN_MIN;
		} Else {
			/* here: form plugin is running; placeholder are replaced in \SentraDesigner\compile\Sentra\compile.paragraphs\compile.form.php */
			$this->Breaks[] = '768';
			$this->Breaks[] = '480';
		}
		$this->gridCountmax = $maxCount;
		if (!empty($split) && array_sum($split) == $this->gridCountmax) {
			$this->gridCount = count($split);
			$this->split = $split;
			for ($x = 0;$x < $this->gridCount;$x++) {
				$this->split[$x] = str_replace('.','_',$split[$x]);
				$this->width[$x] = $split[$x];
			}
		}
		for ($x=0;$x<$this->gridCount;$x++) {
			$this->DecoClass[$x] = '';
		}
	}

	public function Add($content, $clear = false) {
		#if ($this->Index < 0 || $this->Index > ($this->gridCount-1))
		#	 return false;
		if ($clear)
			$this->content[$this->IndexY][$this->Index] = $content;
		else {
			if (!isset($this->content[$this->IndexY][$this->Index]))
				$this->content[$this->IndexY][$this->Index] = $content;
			else
				$this->content[$this->IndexY][$this->Index] .= $content;
			}
		return true;
	}

	public function AddTo($index, $content, $clear = false) {
		// if ($index < 0 || $index > ($this->gridCount-1))
			// return false;
		if ($clear)
			$this->content[$this->IndexY][$index] = $content;
		else {
			if (!isset($this->content[$this->IndexY][$this->Index]))
				$this->content[$this->IndexY][$this->Index] = $content;
			else
				$this->content[$this->IndexY][$this->Index] .= $content;
			}
		return true;
	}

	public function AddToXY($x, $y, $content, $clear = false) {
		if ($clear){
			$this->content[$y][$x] = $content;
		} else {
			If (array_key_exists($y,$this->content)) {
				if (array_key_exists($x,$this->content[$y])) {
					$this->content[$y][$x] .= $content;
				} Else {
					$this->content[$y][$x] = $content;
				}
			} Else {
				$this->content[$y][$x] = $content;
			}
		}
		return true;
	}

	public function GetHtml($DEBUG = FALSE) {
		$e = "";
		If ($DEBUG) DEBUG(count ($this->content));
		for ($y = 0; $y < count ($this->content); $y++) {
			$r = '<div class="griddy-row flex">'.PHP_EOL;
			for ($x = 0;$x < $this->gridCount;$x++) {
				if (!isset($this->content[$y][$x]))
					$this->content[$y][$x] = "";
				$c =  trim($this->content[$y][$x]);
				$d = "";
				If (trim($this->DecoClass[$x]) != '') $d = trim($this->DecoClass[$x]).' ';
				if ($c == "") {
#					$d = " hide ";
				}
				If (trim($this->BreakClasses[$x]) != '') {
					$this->BreakClasses[$x] = ' '.$this->BreakClasses[$x];
				}
				$r .= '	<div class="flex '.$d.'col-fw-'.$this->gridCountmax.$this->split[$x].$this->BreakClasses[$x].'">'.PHP_EOL;
				If ($d != '') {
					$r .= '		<div class="inner">'.PHP_EOL;
				}
				if ($c != "")
					$r .= $this->content[$y][$x].PHP_EOL;
				else
					$r .= '';
				If ($d != '') {
					$r .= '		</div>	<!-- Close class="inner'.$d.'" -->'.PHP_EOL;
				}
				$r .= '	</div>	<!-- Close class="flex col-fw-'.$this->gridCountmax.$this->split[$x].'" -->'.PHP_EOL;
			}
			$e .= $r.'</div>	<!-- Close class="griddy-row flex" -->'.PHP_EOL;
		}
		return $e;
	}

	public function GetRealWidth($width) {
		if ($this->Index < 0 || $this->Index > ($this->gridCount-1))
			return 300;
		$fact = (100 / $this->gridCountmax) * $this->split[$this->Index];
		$width = ($width / 100) * $fact;
		return $width + 200;
	}

	public function GetCss() {
		global $wb;
		$r = "\n";
		$r .= file_get_contents('./styles/griddy-styles.css');
		$r = str_replace('{{displayFlex}}',GetDisplayFlex_vendor_prefixes(),$r);
		$r = str_replace('{{FlexDirectionColumn}}',GetDisplayFlexDirection_vendor_prefixes('column'),$r);
		if ($this->BreakPoints)
			$r .= "\n".file_get_contents('./styles/griddy-mq-styles.css');
		$r = str_replace('{{Break0}}'			,	$this->Breaks[0],$r);
		$r = str_replace('{{Break1}}'			,	$this->Breaks[1],$r);
		$r = str_replace('{{Base}}'				,	$this->BaseSelector,$r);
		$r = str_replace('{{MaxWidth}}'		,	$this->MaxWidth,$r);
		$r = str_replace('{{GridPadding}}',	$this->GridPadding,$r);
		$r = str_replace('{{GridMargin}}'	,	$this->GridMargin,$r);
		$r = str_replace('{{col0}}'				,	$this->gridCountmax.$this->split[0],$r);
		$r = str_replace('{{col1}}'				,	$this->gridCountmax.$this->split[1],$r);
		$r = rtrim($r);
		$splits = array();
		for ($x = 0;$x < $this->gridCount;$x++) {
			$css = $this->BaseSelector.' .col-fw-'.$this->gridCountmax.$this->split[$x].' {'.PHP_EOL.
						 'width: '.(100/$this->gridCountmax) * $this->width[$x].'%;'.PHP_EOL/*.
						 'min-width:128px;'.PHP_EOL*/;
			If (isset($this->ColPadding[$x])) {
				$css .= 'padding: '.$this->ColPadding[$x].';'.PHP_EOL;
			}
			$css .= '}'.PHP_EOL;;
			if (!in_array($css,$splits))
				array_push($splits,$css);
		}
		$r .= implode('',$splits);
		return $r.PHP_EOL;
	}
}
?>