<?php
class IconBar {
	private $icons = array();
	private $mode = 'color';
	private $wrapperTag = '';
	private $wrapperClasses = '';
	public  $BaseClass = 'aio';
	
	public function __construct($mode='color') {
		if (in_array($mode, array('color','biColor','multiColor','stdlink')))
			$this->mode = $mode;
	}
	
	public function WrapperTag($tag)  {
		$this->wrapperTag = $tag;
	}
	
	public function WrapperClasses($classes)  {
		$this->wrapperClasses = $classes;
	}
	
	public function AddWrapperClass($class)  {
		$this->wrapperClasses .= ' '.trim($class);
	}

	public function GetHTML()  {
		$r = '';
		if ($this->wrapperTag != '') {
			$closeTag = '</'.$this->wrapperTag.'>';
			$classes = $this->BaseClass;
			$r = '<'.$this->wrapperTag;
			if ($this->wrapperClasses != '') {
				$classes .= ' '.trim($this->wrapperClasses);
			}
			$r .= ' class="'.$classes.'">';			
		}	

		if ($this->mode == 'stdlink') {
			for ($x = 0; $x < count($this->icons); $x++) {
				$attr = $this->_getAttr($this->icons[$x]['Attributes']);
				$noWrap = '';	
				if ($this->icons[$x]['AddText'] !=  '') 				
					$noWrap = 'nowrap';
					$LinkClass = '';
				if ($this->icons[$x]['LinkClass'] != '')
					$LinkClass = $this->icons[$x]['LinkClass'].' ';
				$btnMode = 'ibbtn-link';	
				if ($this->icons[$x]['ForceBiColor']) {
					$btnMode = 'ibbtn '.RegCssClassHash('background:'.$this->icons[$x]['BackColor'].';color:'.$this->icons[$x]['ForeColor']);
				}
				$r .= '<a title="" '.$attr.'class="'.$LinkClass.$noWrap.'" '.$this->icons[$x]['Href'].' title="'.$this->icons[$x]['LinkTitle'].'"><span class="'.$btnMode.'"><i class="fa fa-fw fa-'.$this->icons[$x]['AweSomeName'].'"></i>';
				if ($this->icons[$x]['AddText'] !=  '') 
					$r .= '<span class="text">'.$this->icons[$x]['AddText']. '</span>';		
				$r .= '</span></a>';		
			}	
		}
		if ($this->mode == 'color') {
			for ($x = 0; $x < count($this->icons); $x++) {
				$attr = $this->_getAttr($this->icons[$x]['Attributes']);
				$noWrap = '';	
				if ($this->icons[$x]['AddText'] !=  '') 				
					$noWrap = 'nowrap';
					$LinkClass = '';
				if ($this->icons[$x]['LinkClass'] != '')
					$LinkClass = $this->icons[$x]['LinkClass'].' ';
				$btnMode = 'ibbtn-color';	
				if ($this->icons[$x]['ForceBiColor']) {
					$btnMode = 'ibbtn '.RegCssClassHash('background:'.$this->icons[$x]['BackColor'].';color:'.$this->icons[$x]['ForeColor']);
				}
				$r .= '<a title="" '.$attr.'class="'.$LinkClass.$noWrap.'" '.$this->icons[$x]['Href'].' title="'.$this->icons[$x]['LinkTitle'].'"><span class="'.$btnMode.'"><i class="fa fa-fw fa-'.$this->icons[$x]['AweSomeName'].'"></i>';
				if ($this->icons[$x]['AddText'] !=  '') 
					$r .= '<span class="text">'.$this->icons[$x]['AddText']. '</span>';		
				$r .= '</span></a>';		
			}	
		}
		if ($this->mode == 'biColor') {
			for ($x = 0; $x < count($this->icons); $x++) {
				$attr = $this->_getAttr($this->icons[$x]['Attributes']);
				$noWrap = '';				
				if ($this->icons[$x]['AddText'] !=  '') 				
					$noWrap = 'nowrap';
				$btnMode = 'ibbtn-2color';	
				if ($this->icons[$x]['ForceBiColor']) {
					$btnMode = RegCssClassHash('background:'.$this->icons[$x]['BackColor'].';color:'.$this->icons[$x]['ForeColor']);
				}
				$LinkClass = '';
				if ($this->icons[$x]['LinkClass'] != '')
					$LinkClass = $this->icons[$x]['LinkClass'].' ';
				$r .= '<a '.$attr.'class="'.$LinkClass.$noWrap.'" '.$this->icons[$x]['Href'].' title="'.$this->icons[$x]['LinkTitle'].'"><span class="ibbtn '.$btnMode.'"><i class="fa fa-fw fa-'.$this->icons[$x]['AweSomeName'].' '.trim($this->icons[$x]['IconClass']).'"></i>';
				if ($this->icons[$x]['AddText'] !=  '') 
					$r .= '<span class="text">'.$this->icons[$x]['AddText']. '</span>';		
				$r .= '</span></a>';		
			}	
		}
		if ($this->mode == 'multiColor') {	
			$fixedLinks = array('facebook','facebook-square','facebook-official','twitter','twitter-square','gplus','youtube','youtube-play','youtube','youtube-square','pinterest','flickr','instagram','linkedin','whatsapp');
			for ($x = 0; $x < count($this->icons); $x++) {				
				$attr = $this->_getAttr($this->icons[$x]['Attributes']);
				$LinkClass = ' ';
				if ($this->icons[$x]['LinkClass'] != '')
					$LinkClass = $this->icons[$x]['LinkClass'].' ';
				$btnMode = 'ibbtn-2color';
				if (in_array($this->icons[$x]['AweSomeName'], $fixedLinks))
					$btnMode = 'ibbtn-'.$this->icons[$x]['AweSomeName'];
				if ($this->icons[$x]['ForceBiColor']) {
					$btnMode = RegCssClassHash('background:'.$this->icons[$x]['BackColor'].';color:'.$this->icons[$x]['ForeColor']);
				}
				$noWrap = '';	
				if ($this->icons[$x]['AddText'] !=  '') 				
					$noWrap = 'nowrap';
				$r .= '<a '.$attr.'class="'.$LinkClass.$noWrap.'" '.$this->icons[$x]['Href'].' title="'.$this->icons[$x]['LinkTitle'].'"><span class="ibbtn '.$btnMode.'"><i class="fa fa-fw fa-'.$this->icons[$x]['AweSomeName'].' '.trim($this->icons[$x]['IconClass']).'"></i>';
				if ($this->icons[$x]['AddText'] !=  '') 
					$r .= '<span class="text">'.$this->icons[$x]['AddText']. '</span>';		
				$r .= '</span></a>';
			}	
		}
		$r = $this->_cleanAttributtes($r);
		return $this->_removeEmptyClass($r.$closeTag);
	}	
	
	public function GetIconArray() {
		$r = array();
		$r['ForeColor'] = '#ffffff';
		$r['BackColor'] = '#000000';
		$r['AweSomeName'] = 'facebook';
		$r['Attributes'] = array();
		$r['AddText'] = '';
		$r['Href'] = '#';
		$r['IconClass'] = '';
		$r['LinkClass'] = '';
		$r['LinkTitle'] = '';
		$r['ForceBiColor'] = false;
		return $r;
	}
	
	public function SetIcon ($item = array()) {
		if (!empty($item)) {
			array_push($this->icons, $item);
		}
	}
	
	public function SetIconArray ($items = array()) {
		foreach ($items as $item)
			$this->SetIcon($item);
	}
	
	##########################################################################
	
	private function _cleanAttributtes ($d) {
		$links = $this->_extracturl($d);
		foreach ($links as $l) {
			$orgLink = $l[2];
			$l[2] = str_replace("<?",'----?',$l[2]);
			$l[2] = str_replace("?>",'?----',$l[2]);		
			PREG_MATCH('/\>(.*)<\/a>/', $l[2], $matches);
			$lText = $matches[1];
			$l[2] = str_replace($lText,"{{LINK-PLACEHOLDER}}",$l[2]);
			$avalue = '';
			$aname = '';
			$mode = 'stag';
			$data = array();
			$data['attr'] = array();
			$quote = 0;
			$marks = '"';
			for ($x = 0; $x < strlen($l[2]);$x++) {
				$char = $l[2][$x];	
				if ($mode == 'stag' && $char == "<") {
					$tag = true;
					$mode = 'tag';
					$data['tag'] = '';
					continue;
				}
				
				if ($mode == 'tag' && $char != " ") {
					$data['tag'] .= $char;
				} 
				
				if ($mode == 'tag' && $char == " ") {
					$mode = 'skip';
				}
				
				if ($mode == 'skip' && $char == " ") {
					continue;
				} 	
				
				if ($mode == 'skip' && $char != " ") {
					$mode = 'attrname';
				}
				
				if ($mode == 'attrname' && $char != "=") {
					$aname .= $char;
				} 
				
				if ($mode == 'attrname' && $char == "=") {
					$marks = $l[2][$x+1];
					$x++;
					$mode = 'attrvalue';
					continue;
				}
				
				if ($mode == 'attrvalue' && $char != $marks) {
						$avalue .= $char;
				} 
				
				if ($mode == 'attrvalue' && $char == $marks) {
					if (isset($data['attr'][$aname])) {
						$data['attr'][$aname] .= ' '.trim($avalue);
					} else {
						$data['attr'][$aname] = trim($avalue);
					}
					$aname = $avalue = '';
					$mode = 'skip';
				}			
			}
			$rep = '<'.$data['tag'];
			foreach ($data['attr'] as $k => $v) {
				$rep .= ' '.$k.'="'.$v.'"';				
			}
			$rep .= ">{{LINK-PLACEHOLDER}}</".$data['tag'].'>';
			$rep = str_replace('{{LINK-PLACEHOLDER}}',$lText,$rep);
			$rep = str_replace('----?',"<?",$rep);
			$rep = str_replace('?----',"?>",$rep);
			$d = str_replace($orgLink,$rep,$d);
		}
		return $d;
	}
	
	private function _extracturl($html){
		$linkArray = array();
		if(preg_match_all('/<a\s+.*?(href|noref)=[\"\']?([^\"\' >]*)[\"\']?[^>]*>(.*?)<\/a>/i',$html,$matches,PREG_SET_ORDER)){
			foreach($matches as $match){
				$tmp = str_replace("about:dummy|","",$match[1]);
				array_push($linkArray,array($tmp,$match[2],$match[0]));
			}
		}
		return $linkArray;
	}
	
	private function _removeEmptyClass ($code) {
		$code = str_replace('class="" ','',$code);
		return $code;
	}
	
	private function _getAttr ($attributes) {
		$attr = ' ';
		if (!empty($attributes)) {
			foreach ($attributes as $k => $v) {
				$attr .= $k .'="'.$v.'" ';
			}
			$attr = trim($attr).' ';
		}
		return $attr;
	}
	
}

?>