<?php

class MakePagination {

	var $currentPage = 0;
	var $totalPages = 0;
	var $url = '';
	var $anchor="";
	var $pageProperty = "page";
	var $designerMode = false;
	var $backText = 'Back';	
	var $nextText = 'Next';
	var $pageOf = '<b>{{c}}</b>/{{t}}';
	var $compactSplitter='<span class="divider">&hellip;</span>';
	var $backNextTpl = '<div class="%1$s{{disabled}}{{backnext}}">%2$s</div>';
	var $linkTpl = '<div class="%1$s{{selected}}">%2$s</div>';
	var $innerPart = 5;
	var $spaceBackNext="";
	var $divClass = "";
	var $backNextClass = "";
	var $DecoContainer = array("DivStart" => "",
	                            "DivEnd" => "",
	                            "BackNextClass" => "");


	
	var $hideByOnlyOnePage = false;
	var $mobileType = "simple";
	var $fixedMode = false;
	var $wrapperMode = false;
	var $useMobileBg = false;

	var $linkFormat = "{{Link}}";
	var $pageFormat = "{{Page}}";
	var $backNextFormat = "{{Navi}}";
	var $hideDisabledButtons = false;
	var $hideBackNextButtons = false;

	var $showIcons = true;
	var $iconBack ="fa fa-angle-double-left";
	var $iconNext = "fa fa-angle-double-right";

	

	function __construct($_totalCount, $_currentPage = 1) {
		$this->currentPage = $_currentPage;
		$this->totalPages = $_totalCount;
		$this->url = $_SERVER['PHP_SELF'];
	}

	function GetPagination() {
		if ($this->totalPages < 1)
			return '';
		if ($this->fixedMode)
			return '<div class="pagination">'.$this->GetStandardPagination().'</div>';
		else
			return '<div class="pagination">'.$this->GetStandardPagination().$this->GetMobilePagination().'</div>';
	}

	function GetStandardPagination() {

    if ($this->hideByOnlyOnePage)
        {
        if ($this->totalPages < 2) 
			{
			if (!$this->designerMode)
				return "";
			else
				return '<div class="standard">Nur eine Seite wird nicht dargestellt</div>';
			}
        }

	$nextText = $this->nextText;
	$backText = $this->backText;
	if ($this->showIcons)
		{
		$nextText = '<i class="'.$this->iconNext.'"></i>';
		$backText = '<i class="'.$this->iconBack.'"></i>';
		}

	$link = sprintf($this->linkTpl,$this->linkFormat,'%s');
	$llink = str_replace('{{selected}}',' last',$link);
	$link = str_replace('{{selected}}','',$link);
	$page = sprintf($this->linkTpl,$this->pageFormat,'%s');
	$lpage = str_replace('{{selected}}',' selected last',$page);
	$page = str_replace('{{selected}}',' selected',$page);

    $first = sprintf($this->backNextTpl,$this->backNextFormat,$backText);
	$first = str_replace('{{backnext}}',' first',$first);
	
	if ($this->currentPage == 1)
		$first = str_replace('{{disabled}}',' disabled',$first);
	else
		$first = str_replace('{{disabled}}','',$first);

	$last = sprintf($this->backNextTpl,$this->backNextFormat,$nextText);
	$last = str_replace('{{backnext}}',' last next',$last);
	
	if ($this->totalPages == 1 && ($this->hideBackNextButtons || $this->hideDisabledButtons))
		$page = $lpage;

	if ($this->currentPage == $this->totalPages)
		$last= str_replace('{{disabled}}',' disabled',$last);
	else
		$last = str_replace('{{disabled}}','',$last);

    $result = '';
    $i = 1;

    if ($this->anchor != '' && substr ($this->anchor,0,1) != '#')
        $this->anchor = '#'.$this->anchor;
if ($this->wrapperMode)
	$result .= '<div class="part-left">';
if (!$this->hideBackNextButtons)
{
    if ($this->currentPage > 1)
		{			
		$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'='.($this->currentPage - 1).$this->anchor.'">'.$first.'</a>';
		}
	else
		{
		if (!$this->hideDisabledButtons)
			$result .= $first;
		else
			{
			if ($this->wrapperMode)	
				 $result .= '&nbsp;';
			else
				 $result .= '';
			}
		}
}
else
{
if ($this->wrapperMode)	
 $result .= '&nbsp;';
else
 $result .= '';


}
if ($this->wrapperMode)
	$result .= '</div><div class="part-center"><div class="part-inner">';

		if ($i == $this->currentPage)	
			$result .= sprintf($page,$i);
		else
			$result .=  '<a href="'.$this->url.'&amp;'.$this->pageProperty.'='.$i.$this->anchor.'">'.sprintf($link,$i).'</a>';


    if (($this->currentPage > 4) and ($this->totalPages > 6))
		$result .=  $this->compactSplitter;


    
for ($i = ($this->currentPage < $this->totalPages-2 ? $this->currentPage:$this->totalPages-2)-2;
		$i <= ($this->currentPage > 3?$this->currentPage:3)+2;
		$i++)

{
        if (($i > 1) and ($i < $this->totalPages)) 
			$result .=  ($i == $this->currentPage?sprintf($page,$i,$i):'<a  href="'.$this->url.'&amp;'.$this->pageProperty.'='.$i.$this->anchor.'">'.sprintf($link,$i).'</a>');
	
}

    if (($this->currentPage < $this->totalPages-3) and ($this->totalPages > 6)) $result .=  $this->compactSplitter;
  
  $i = $this->totalPages;

if ($this->hideBackNextButtons || ($this->hideDisabledButtons && $this->currentPage == $this->totalPages))
	{
	$page = $lpage;
	$link = $llink;
	}


  if ($this->totalPages > 1) 
	$result .=  ($i == $this->currentPage ?sprintf($page,$i):'<a  href="'.$this->url.'&amp;'.$this->pageProperty.'='.$i.$this->anchor.'">'.		  sprintf($link,$i).'</a>');
//$result .= '</div>';
if ($this->wrapperMode)
	$result .= '</div></div><div class="part-right">';
if (!$this->hideBackNextButtons )
{
if ($this->currentPage < $this->totalPages )
	{ 
		$result .=  '<a href="'.$this->url.'&amp;'.$this->pageProperty.'='.($this->currentPage + 1).$this->anchor.'">'.$last.'</a>';
	}
else
		{
		if (!$this->hideDisabledButtons)
			$result .= $last;
		}
}
if ($this->wrapperMode)
	$result .= '</div>';

    return('<div class="stand"><div class="standard">'.$result.'</div></div>');
	}




function GetMobilePagination() 
	{
		if ($this->mobileType == "simple")
		{
			if ($this->useMobileBg)
			{
			$bgStart = '<div class="mob">';
			$bgEnd = '</div>';
			}
		else
			{
			$bgStart = '';
			$bgEnd = '';
			}

		$result = '<div class="mobile">';
		if ($this->hideByOnlyOnePage)
	        {
	        if ($this->totalPages < 2) 
				{
				if (!$this->designerMode)
					return "";
				else
					return '<div class="mobile">Nur eine Seite wird nicht dargestellt</div>';
				}
	        }

		$next = sprintf($this->linkTpl,$this->backNextFormat,'<span class="icon"><i class="fa fa-angle-right"></i></span>');		
		$next = str_replace('{{selected}}','',$next);
		$back = sprintf($this->linkTpl,$this->backNextFormat,'<span class="icon"><i class="fa fa-angle-left"></i></span>');		
		$back = str_replace('{{selected}}','',$back);

		
		$rewind = sprintf($this->linkTpl,$this->backNextFormat,'<span class="icon"><i class="fa fa-angle-double-left"></i></span>');		
		$rewind = str_replace('{{selected}}','',$rewind);

		$s= array('{{c}}','{{t}}');
		$r= array($this->currentPage,$this->totalPages);
		$page = sprintf($this->linkTpl,'btn btn-userpage',str_replace($s,$r,$this->pageOf));		
		$page = str_replace('{{selected}}',' selected',$page);
		$page = str_replace('button','div',$page);

		if ($this->totalPages == 1)
			{
			$result .= $page;
			return($bgStart.$result.$bgEnd.'</div>');
			}
		if ($this->currentPage > 2)
			{
				$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'=1'.$this->anchor.'">'.$rewind.'</a>';

			}

		if ($this->currentPage == 1)
		{	
			//$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'=1'.$this->anchor.'">'.$back.'</a>';	
			$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'=2'.$this->anchor.'">'.$next.'</a>';
		}
	
	if ($this->currentPage > 1 && $this->currentPage < $this->totalPages+1)
		{
			$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'='.($this->currentPage-1).$this->anchor.'">'.$back.'</a>';	
		}
	
		if ($this->currentPage > 1 && $this->currentPage < $this->totalPages)
		{
			$result .= '<a href="'.$this->url.'&amp;'.$this->pageProperty.'='.($this->currentPage+1).$this->anchor.'">'.$next.'</a>';
		}
		$result .= $page;
		return($bgStart.$result.$bgEnd.'</div>');
		}
	}
}

?>






















