<?php
/*
 * \SentraDesigner\fills\Teaser\scripts\teaser.vtd.class.php
 */

class VTD_Teaser {
	private	$BAuthorLine=TRUE; 			/* Flag, indicating if the author line shall be printed                                  */
	private $BCaptionLine = TRUE;   /*                                                                                       */
	private	$BAddTextLine=TRUE;			/* Flag, indicating if the addtext line shall be printed                                 */
	private	$BMoreLine=TRUE;				/* Flag, indicating if a more line wih a link to the corresponding page shall be printed */
	private $moretxt;
	private $newtxt;
	private $Apply_Header_Highlight = FALSE;
	private $LegendAuthor='';
	private $TXT_Empty;
	private $TeaserContents;
	private $t;											/* Local copy of a single teasercontent */
	private $LegendMore='Weiterlesen...';
	private	$ImageLink=0;						/* 0 = no link/1 = link to reference page/ 2 = enlarge image with prettyPhoto / 3 = prettyPhoto group 1 / 4 = prettyPhoto group 2 */
	private	$BImageLink=TRUE;
	private $ImagePosition;
	private $ImagePosition_left=FALSE;
	private $TeaserType;
	private $ImgWidth;
	private $ThumbnailWidth;
	private $ThumbnailHeight;
	private $ColumnCount;
	private $ShowNewIcon=FAlSE;
	private $newiconHTML;
	private $NewIconName;
	private $NewIconPosition;
	private $MyImages;
	private $moreline='';
	private $TeaserMode='1';
	private $HeaderPosition='top';
	private $BHideContent=FALSE;
	private $BAnimateContent=FALSE;
	private $MoreAnimateClass='';
	private $ShorttextAnimateClass='';
	private $ImgBorderClass='';
	private $ImageFormat='';
	private $PLUGIN_IMAGES;
	private $Bcompile_author;				/* Local flag indicating if the author line shall be printed */
	private $TeaserGriddy;
	private $HeaderClass;
	private $ActiveTeaser;
	private $TsrHTML;
	private $NoPicpic;

	public function __construct	(	$PLUGIN_PARAMETER,
																$TeaserContents,
			            							$PLUGIN_IMAGES
															)
{		global $wb;
		$this -> OptionsBg 							= $PLUGIN_PARAMETER['options']['bg'];
		$this -> OptionsBreak 					= $PLUGIN_PARAMETER['options']['break'];
		$this -> OptionsImgWidth 				= $PLUGIN_PARAMETER['options']['ImgWidth'];
		$this -> TeaserContents	 				= $TeaserContents;
		$this -> PLUGIN_IMAGES 	 				= $PLUGIN_IMAGES;
		$this -> MyImages 			 				= $wb->MyImages;
		$this -> ActiveTeaser 	 				= $PLUGIN_PARAMETER['ActiveTeaser'];
		$this -> TeaserMode      				= $PLUGIN_PARAMETER['TeaserMode'];
		$this -> BHideContent		 				= $PLUGIN_PARAMETER['BHideContent'];
		$this -> BAnimateContent 				= $PLUGIN_PARAMETER['BAnimateContent'];
		$this -> BAnimateShorttext 			= $PLUGIN_PARAMETER['BAnimateShorttext'];
		$this -> BAnimateMore	 					= $PLUGIN_PARAMETER['BAnimateMore'];
		$this -> MoreAnimateClass				= $PLUGIN_PARAMETER['MoreAnimateClass'];
		If (!$this -> BHideContent) {
			$this -> BAnimateContent 			= FALSE;
			$this -> BAnimateShorttext 		= FALSE;
			$this -> BAnimateMore	 				= FALSE;
			$this -> MoreAnimateClass			= '';
		}
		$this -> ShorttextAnimateClass	= $PLUGIN_PARAMETER['ShorttextAnimateClass'];
		$this -> ImgBorderClass					= $PLUGIN_PARAMETER['__ImgBorderClass__'];
		If (!isset($PLUGIN_PARAMETER['ImageFormat']))$PLUGIN_PARAMETER['ImageFormat'] = 1;
		$this -> ImageFormat						= $PLUGIN_PARAMETER['ImageFormat'];
		$this -> NoPicpic								= $PLUGIN_PARAMETER['NoPicpic'];
		$this -> ColumnCount						= 1;
		if (isset($PLUGIN_PARAMETER['Columns'])) $this -> ColumnCount = $PLUGIN_PARAMETER['Columns'];

		$this -> HeaderHighlightMode		= '';
		$this -> Apply_Header_Highlight = FALSE;
		if (isset($PLUGIN_PARAMETER['HeaderHighlight'])) $this -> Apply_Header_Highlight = ConvertToBool($PLUGIN_PARAMETER['HeaderHighlight']);

		$this -> ShowNewIcon = FALSE;
		if (isset($PLUGIN_PARAMETER['ShowNewIcon'])) $this -> ShowNewIcon = ConvertToBool($PLUGIN_PARAMETER['ShowNewIcon']);

		$this -> newiconPosition = 0;/* 0=Header; 1=Text area; 2=image; 3=More...line */
		if (isset($PLUGIN_PARAMETER['NewIconPosition'])) $this -> newiconPosition = $PLUGIN_PARAMETER['NewIconPosition'];

		SWITCH ($PLUGIN_PARAMETER['TeaserMode']){
			case 0:	{# small image, left aligned
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 0;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 0;
			}break;

			case 1:	{# small image, right aligned
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 1;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 0;
			}break;

			case 2:	{# just text, no image
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = -1;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 2;
			}break;

			case 3:	{# alternating right and left; half width of column width
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 2;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 1;
			}break;

			case 4:	{# large image, in the middle between caption and teaser text
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 3;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 1;
			}break;

			case 5:	{# large image, on bottom of column
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 4;

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 1;
			}break;

			case 6: {
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 3;
				$this -> HeaderPosition = 'top';

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 1;

			}break;

			case 7: {
				/*ImagePosition 0 ... left
				 *							1 ... right
				 *							2 ... alternating right and left; half width of column width
				 *							3 ... middle
				 *							4 ... bottom
				 */
				$this -> ImagePosition = 4;
				$this -> HeaderPosition = 'bottom';

				/* TeaserType 	0 ... small Image
				 * 							1 ... Large Image
				 * 							2 ... no Image
				 */
				$this -> TeaserType = 1;

			}break;

		}
		/* *************************************************************** */
		$Texts = unserialize(ConvertSerializedIni($PLUGIN_PARAMETER['Texts'],true));
		If (isset($Texts['TXT-New'])) {
			$this -> newtxt = $Texts['TXT-New'];
		} Else {
			$this -> newtxt = "Neu";
		}
		If (isset($Texts['TXT-More'])) {
			$this -> moretxt = $Texts['TXT-More'];
		} Else {
			$this -> moretxt = "see more ...";
		}
		If ($PLUGIN_PARAMETER['MoreMode'] == '1') {
			/* Show a button */
			$this -> moreline = '<button class="'.$PLUGIN_PARAMETER['BtnClass'].'">'.PHP_EOL.
													'	'.$this -> moretxt.PHP_EOL.
													'</button>';
		} Else {
			/* Just show the more-text */
			$this -> moreline = $this -> moretxt;
		}

		If (isset($Texts['TXT-Autor'])) {
			$this -> LegendAuthor = $Texts['TXT-Autor'];
		} Else {
			$this -> LegendAuthor = "Autor:";
		}
		$this -> TXT_Empty =" ... ";
		if (isset($Texts['TXT-Empty'])) $this -> TXT_Empty = $Texts['TXT-Empty'];

		$this -> ImageLink = 0;
		if (isset($PLUGIN_PARAMETER['ImageLink'])) $this -> ImageLink = $PLUGIN_PARAMETER['ImageLink'];
		if ($this -> ImageLink > 1) $wb->PRETTY_ONPAGE = true;

		$this -> BAuthorLine       = TRUE;
		if (isset($PLUGIN_PARAMETER['AuthorLine'])) $this -> BAuthorLine = ConvertToBool($PLUGIN_PARAMETER['AuthorLine']);

		$this -> BAddTextLine  = TRUE;
		if (isset($PLUGIN_PARAMETER['DescriptionLine'])) $this -> BAddTextLine = ConvertToBool($PLUGIN_PARAMETER['DescriptionLine']);

		$this -> BMoreLine					= TRUE;
		if (isset($PLUGIN_PARAMETER['MoreLine'])) $this -> BMoreLine = ConvertToBool($PLUGIN_PARAMETER['MoreLine']);

		If (defined ('SENTRA_DESIGNER')) {
			/* Here: the class is used inside VTD (Visual Template Designer) */
			require_once('../../scripts/assets/griddy/griddy.class.php');
		} Else {
			/* Here: the class is used inside SENTRA */
			require_once('../../moduls/griddy/griddy.class.php');
		}
		$ColumnCount = $this -> ColumnCount;

		If (defined ('SENTRA_DESIGNER')) {
			require('./render.scripts/newteasergriddy.php');
		} Else {
			require(DESIGNRENDERSCRIPTS.'newteasergriddy.php');
		}
		$this -> TeaserGriddy = $TeaserGriddy;
		$this -> TeaserGriddy -> DecoClass = 'deco';
		If ($this -> BAnimateContent)
			$this -> TeaserGriddy -> DecoClass .= ' animo';
		$this -> HeaderClass = 'class="header';
		If ($this -> Apply_Header_Highlight) {
			$this -> HeaderClass .= ' HdrHL';
		}
		$this -> HeaderClass .= '"';
		$this -> newiconHTML = '';

}
  /*
   * The class destructor.
   *
   * Explicitly clears Parser object from memory upon destruction.
   */
  public function __destruct()
  {
      unset($this);
      return;
  }

/* ==========================================================================
 * vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
 */
	private function Fcompile_ImageLink($BImgClass=TRUE)
	{
		global $wb;
		If (isset($this -> t['image']) && $this -> t['image'] == "") {
			$this -> t['image'] = $this -> NoPicpic;
			If (!defined("SENTRA_DESIGNER")) {
				copy(DESIGNPATH.'images/'.$this -> t['image'], $this -> MyImages.$this -> t['image']);
			}
		}
		if (isset($this -> t['image']) && $this -> t['image'] != "") {
			$this -> t['image'] = Str::MakeUTF8($this -> t['image']);
			$imgpath = $this -> MyImages.$this -> t['image'];
			list($imgWidth,
					 $imgHeight,
					 $imgtype,
					 $imgattr) = getimagesize($imgpath);
			$minWidth = $imgWidth;
			if ($imgHeight > $imgWidth)
				$minWidth = $imgHeight;

			SWITCH($this -> ImageFormat) {
				case 0: {	/* = Original */
					$this -> ThumbnailWidth  = $imgWidth;
					$this -> ThumbnailHeight = $imgHeight;
					$maxWidthCSS = 'style="max-width:'.$imgWidth.'px;"';
				}break;

				case 1: {	/* = 1:1 */
					$this -> ThumbnailWidth  = $minWidth;
					$this -> ThumbnailHeight = $minWidth;
					$maxWidthCSS = 'style="max-width:'.$minWidth.'px;"';
				}break;

				case 2: {	/* = 4:3 */
					$width = floor(4 * ($minWidth/3));
					$this -> ThumbnailWidth  = $imgWidth;
					$this -> ThumbnailHeight = ($imgWidth / 4) * 3;
					$maxWidthCSS = 'style="max-width:'.$width.'px;"';
				}break;

				case 3: {	/* = 3:2 */
					$width = floor(3 * ($minWidth/2));
					$this -> ThumbnailWidth  = $imgWidth;
					$this -> ThumbnailHeight = ($imgWidth / 3) * 2;
					$maxWidthCSS = 'style="max-width:'.$width.'px;"';
				}break;

				case 4: {	/* = 16:9 */
					$width = floor(16 * ($minWidth/9));
					$this -> ThumbnailWidth  = $imgWidth;
					$this -> ThumbnailHeight = ($imgWidth / 16) * 9;
					$maxWidthCSS = 'style="max-width:'.$width.'px;"';
				}break;
			}

			$maxWidthCSS = '';
			$options['break'] = $this -> OptionsBreak;
			$options['bg'] = $this -> OptionsBg;
			$imgWidth = $this -> OptionsBreak;

			If (!defined ('SENTRA_DESIGNER')) {
				$imgWidth = $wb->TEMPLATE_WIDTHES['Width'];
			}

			if ($this->TeaserMode < 4) {
				$options['break'] = (($imgWidth /100) * ($this -> OptionsImgWidth) / ($this->ColumnCount))  ;
				$img = RegPluginImage($imgpath);
				$LIMAGES = new ImageHandler();
				$LIMAGES->animated=true;
				$LIMAGES->SetSource($imgpath);
				$imgS = $LIMAGES->Thumbnail($this -> ThumbnailWidth, $this -> ThumbnailHeight, $options);
				if ($LIMAGES->getActWidth() > $options['break']) {
					$maxWidth = ((768 /100) * $this -> OptionsImgWidth) / ($this->ColumnCount)  ;
					$LIMAGES->SetSource($imgS);
					$imgS = $LIMAGES->RegResize($maxWidth,null);
				} else {
					$imgS = RegResizedImage($imgS);
				}
				$LIMAGES->SetSource($imgpath);
				$options['break'] = ($this -> OptionsBreak /100) * $this -> OptionsImgWidth;
				$imgL = $LIMAGES->Thumbnail($this -> ThumbnailWidth, $this -> ThumbnailHeight, $options);
				if ($LIMAGES->getActWidth()  > $options['break']) {
					$maxWidth = ((768 /100) * $this -> OptionsImgWidth)  ;
					$LIMAGES->SetSource($imgL);
					$imgL = $LIMAGES->RegResize($maxWidth,null);
				} else {
					$imgL = RegResizedImage($imgL);
				}
			} else {
				$options['break'] = $imgWidth / $this->ColumnCount  ;
				$img = RegPluginImage($imgpath);
				$LIMAGES = new ImageHandler();
				$LIMAGES->animated=true;
				$LIMAGES->SetSource($imgpath);
				$imgS = $LIMAGES->Thumbnail($this -> ThumbnailWidth, $this -> ThumbnailHeight, $options);

				if ($LIMAGES->getActWidth() > $options['break']) {
					$maxWidth = $imgWidth / $this->ColumnCount  ;
					$LIMAGES->SetSource($imgS);
					$imgS = $LIMAGES->RegResize($maxWidth,null);
				} else {
					$imgS = RegResizedImage($imgS);
				}
				$LIMAGES->SetSource($imgpath);
				$options['break'] = $this->OptionsBreak;
				$imgL = $LIMAGES->Thumbnail($this -> ThumbnailWidth, $this -> ThumbnailHeight, $options);
				if ($LIMAGES->getActWidth()  > $options['break']) {
					$maxWidth = $this->OptionsBreak  ;
					$LIMAGES->SetSource($imgL);
					$imgL = $LIMAGES->RegResize($maxWidth,null);
				} else {
					$imgL = RegResizedImage($imgL);
				}
			}





			If (defined("SENTRA_DESIGNER")) {
				$pathdetails = pathinfo($imgS);
				$targetpath = HTDOCS.'assets/images/'.$pathdetails['basename'];
				If(!file_exists($targetpath)) rename($imgS, $targetpath);
				$imgS = $pathdetails['basename'];


				$pathdetails = pathinfo($imgL);
				$targetpath = HTDOCS.'assets/images/'.$pathdetails['basename'];
				If(!file_exists($targetpath)) rename($imgL, $targetpath);
				$imgL = $pathdetails['basename'];


			}


	/* ImageLink:: 0 = no link
	 *             1 = link to reference page
	 *             2 = enlarge image with prettyPhoto
	 *             3 = prettyPhoto group 1
	 *             4 = prettyPhoto group 2
	 */
			$ImgBorderClass = '';
			If ($BImgClass) {
	 			$ImgBorderClass = $this -> ImgBorderClass;
	 		}
	 		// $ImgBorderClass = $this -> ImgBorderClass;
			$ImgBorderClass .= ' responsimg ';

	 		// If ($this -> ImgBorderClass != '')
			$ImgBorderClass = 'class="'.trim($ImgBorderClass).'" ';
	 		$OptionsBreak = $this -> OptionsBreak +1 ;
			If (!defined ('SENTRA_DESIGNER') && $wb->PREVIEW) {
				$imgL = $imgS;
			}

			// $dataLine = '';

			// if ($this -> ThumbnailWidth < $OptionsBreak) {
				$dataLine = 'data-responsimg'.$OptionsBreak.'="'.$this ->PLUGIN_IMAGES.$imgS.'" ';
			// }



			SWITCH ($this -> ImageLink) {
				case 0:/* no link */
				default:
					$linktag 			= PHP_EOL;
					$imagetag			= '		<img '.$dataLine.$ImgBorderClass.$maxWidthCSS.' src="'.$this ->PLUGIN_IMAGES.$imgL.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL;
					$closelinktag = PHP_EOL;
				break;

				case 1:	// link to reference page
					$linktag 			= PHP_EOL.'	<a '.make_link($this -> t).'>'.PHP_EOL;
					$imagetag			= 				'		<img '.$dataLine.$ImgBorderClass.$maxWidthCSS.' src="'.$this ->PLUGIN_IMAGES.$imgL.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL;
					$closelinktag = PHP_EOL.'	</a>'.PHP_EOL;
				break;

				case 2:	// enlarge image with prettyphoto
					$wb->PRETTY_ONPAGE = TRUE;
					$linktag 			= PHP_EOL.'	<a href="'.$this ->PLUGIN_IMAGES.$img.'" '.$wb->PrettyAttr.'="prettyPhoto">'.PHP_EOL;
					$imagetag			= 				'		<img '.$dataLine.$ImgBorderClass.$maxWidthCSS.' src="'.$this ->PLUGIN_IMAGES.$imgL.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL;
					$closelinktag = PHP_EOL.'	</a>'.PHP_EOL;
				break;
				case 3:	// enlarge image with prettyphoto in group 1
					$wb->PRETTY_ONPAGE = TRUE;
					$linktag 			= PHP_EOL.'	<a href="'.$this ->PLUGIN_IMAGES.$img.'" '.$wb->PrettyAttr.'="prettySlide[Group1]">'.PHP_EOL;
					$imagetag			= 				'		<img '.$dataLine.$ImgBorderClass.$maxWidthCSS.' src="'.$this ->PLUGIN_IMAGES.$imgL.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL;
					$closelinktag = PHP_EOL.'	</a>'.PHP_EOL;
				break;
				case 4:	// enlarge image with prettyphoto in group 2
					$wb->PRETTY_ONPAGE = TRUE;
					$linktag 			= PHP_EOL.'	<a href="'.$this ->PLUGIN_IMAGES.$img.'" '.$wb->PrettyAttr.'="prettySlide[Group2]">'.PHP_EOL;
					$imagetag			= 				'		<img '.$dataLine.$ImgBorderClass.$maxWidthCSS.' src="'.$this ->PLUGIN_IMAGES.$imgL.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL;
					$closelinktag = PHP_EOL.'	</a>'.PHP_EOL;
				break;
			}
			$ImagePosition = $this -> ImagePosition;
		} Else {
			$linktag = PHP_EOL;
			$imagetag= PHP_EOL;
			$closelinktag = PHP_EOL;
			$ImagePosition = -1;
		}
		return array($linktag, $imagetag, $closelinktag, $ImagePosition);
	}

	private function compile_newicon_html() {

			$this -> newiconHTML = '';
			If ($this -> ShowNewIcon) {
				If (isset($this -> t['IsNew']) && $this -> t['IsNew']=="True") {
					$this -> newiconHTML =
					'<div class="newicon">'.PHP_EOL.
					'	<a '.make_link($this -> t).'>'.PHP_EOL.
					'		'.$this -> newtxt.PHP_EOL.
					'	</a>'.PHP_EOL.
					'</div>	<!-- Close class="newicon" -->'.PHP_EOL;
				}
			}

	}

	private function Fcompile_largeimg ($BImgClass=TRUE)
	{
		global $wb;
		$html = PHP_EOL;
		// Add teaser image, full width
	  list($linktag, $imagetag, $closelinktag, $ImagePosition) = $this -> Fcompile_ImageLink($BImgClass);
		$html.= '	<div class="fullimage">'.PHP_EOL.
						'		'.$linktag.$imagetag.$closelinktag.PHP_EOL;
/*
		If ($this -> newiconPosition == 2) {	// inside the picture
				$html .= $this -> newiconHTML;
		}
*/
		$html.= '	</div> <!-- Close class="fullimage" -->'.PHP_EOL;
		return $html;
	}
	private function Fcompile_headlines()
	{
		$html = '<div '.$this -> HeaderClass.'>'.PHP_EOL.
						$this -> Fcompile_authorlines ().
						$this -> Fcompile_AddTextlines().
						$this -> Fcompile_captionlines();
/*
		If ($this -> newiconPosition == 0) {	// inside head lines
			If ($this -> newiconHTML != "") {
					$html .= $this -> newiconHTML;
			}
		}
*/
		$html .= '</div>	<!-- Close '.$this -> HeaderClass.' -->'.PHP_EOL;
		return $html;
	}
	private function Fcompile_AddTextlines()
	{

		$html = "";
		If ($this -> BAddTextLine) {
			If ($this -> Bcompile_addtext && strlen($this -> t['addtext']) > 0) {
				If ( $this -> t['addtext'] != "&nbsp;") RegisterSearch($this -> t['addtext']);
				$html = PHP_EOL.'	<h5>'.
								PHP_EOL.'		'.$this -> t['addtext'].
								PHP_EOL.'	</h5>'.
								PHP_EOL;
			}
		}
		return $html;
	}
	private function Fcompile_authorlines()
	{
		global $wb;
		$html = "";
		If ($this -> BAuthorLine) {
			If (isset($this -> t['author'])) {
#				DEBUG($this -> t['author']);
#				RegisterSearch($this -> t['author']);
				SWITCH ($wb -> TEMPLATE_WIDTHES['Mode']) {
					case  "S_Width":
					case "T_Width":
						$lb = ":<br/>&nbsp;";
					break;

					default:
						$lb = ": ";
					break;
				}

				If (strlen($this -> t['author']) > 0 && $this -> t['author']!="&nbsp;") {
					$html = PHP_EOL.'	<h4>'.
									PHP_EOL.'		'.$this -> LegendAuthor.$lb.$this -> t['author'].
									PHP_EOL.'	</h4>'.
									PHP_EOL;
				} Else {
					$html = PHP_EOL.'	<h4>'.
									PHP_EOL."		&nbsp;".
									PHP_EOL.'	</h4>'.
									PHP_EOL;
				}
			}
		}
		return $html;
	}
	private function Fcompile_captionlines()
	{
		$caption_content = "";
		If ($this -> t['caption']!="&nbsp;") {
			RegisterSearch($this -> t['caption']);
			If ($this -> t['ShowAwe'] == 'True') {
				$caption_content = '	<h3>'.PHP_EOL.
													 '		<a '.make_link($this -> t).'>'.PHP_EOL.
													 '			<span>'.PHP_EOL.
													 '				<i class="fa '.$this -> t['AweName'].'"></i>'.PHP_EOL.
													 '				'.print_caption($this -> t).PHP_EOL.
													 '			</span>'.PHP_EOL.
													 '		</a>'.PHP_EOL.
													 '	</h3>'.PHP_EOL;
			} Elseif (isset($this -> t['icon']) && $this -> t['icon'] != "") {
				$img = RegPluginImage($this -> MyImages.$this -> t['icon']);
				$caption_content = '	<h3>'.PHP_EOL.
													 '		<a '.make_link($this -> t).'>'.PHP_EOL.
													 '			<span>'.PHP_EOL.
													 '				<img class="tsricon" src="'.$this ->PLUGIN_IMAGES.$img.'" alt="'.print_caption($this -> t).'"/>'.PHP_EOL.
													 '				'.print_caption($this -> t).PHP_EOL.
													 '			</span>'.PHP_EOL.
													 '		</a>'.PHP_EOL.
													 '	</h3>'.PHP_EOL;
			} Else {
				$caption_content = '	<h3>'.PHP_EOL.
													 '		<a '.make_link($this -> t).'>'.PHP_EOL.
'			<span>'.PHP_EOL.
													 '		'.print_caption($this -> t).PHP_EOL.
 '			</span>'.PHP_EOL.
													 '		</a>'.PHP_EOL.
													 '	</h3>'.PHP_EOL;
			}
		}
/*
		If ($caption_content!= "") {
			If ($this -> newiconPosition == 0) {	// inside head lines
				If ($this -> newiconHTML != "") {
					$caption_content .='<p class="newicon"></p>'.PHP_EOL;
					$caption_content .= $this -> newiconHTML;
				}
			}
		}
*/
		return $caption_content;
	}
	private function Fcompile_teaser_contents()
	{

		$html = "";
		If ($this -> BHideContent) {
			$cclass = 'tsrcnt hc';
			$c0class = 'tsrcnt0 hc';
		} Else {
			$cclass = 'tsrcnt';
			$c0class = 'tsrcnt0';
		}
		$ShortText 		= $this -> Fcompile_single_column_content($this -> t['ShortText']);

		SWITCH ($this -> ImagePosition) {
			case -1: 	// No image at all
			case 0:		//  left hand aligned
			case 1:		//  right hand aligned
			case 2:		{//  alternating right and left half width of column width
				If ($this -> BAnimateShorttext) {
					$ShortText = '<div class="animated '.$this -> ShorttextAnimateClass.'">'.PHP_EOL.
											 '	'. $ShortText . PHP_EOL .
											 '</div>' . PHP_EOL;
				}
				$html .= '<div class="'.$cclass.'">'.PHP_EOL.
									$ShortText.
								 '</div> 	<!-- Close class="'.$cclass.'" -->'.PHP_EOL;
			}break;

			case 3:		{//  large image middle aligned
				$content  = PHP_EOL.$this -> Fcompile_largeimg ();
				$content .= PHP_EOL.$ShortText;
				If ($this -> BAnimateShorttext) {
					$content = '<div class="animated '.$this -> ShorttextAnimateClass.'">'.PHP_EOL.
										 '	'. $content . PHP_EOL .
										 '</div>' . PHP_EOL;
				}
				$html.= '<div class="'.$cclass.'">'.
									$content.
								'</div>		<!-- close class="'.$cclass.'"-->'.PHP_EOL;
			}break;

			case 4:	{	//  large image bottom aligned
				$maxShortText = $this -> Fcompile_single_column_content($this -> t['maxShortText']);
				$content0 = PHP_EOL.$maxShortText.PHP_EOL.
										$this -> Fcompile_largeimg ();
				$content  = PHP_EOL.$ShortText.PHP_EOL;
				If ($this -> BAnimateShorttext) {
					$content0 = '<div class="animated '.$this -> ShorttextAnimateClass.'">'.PHP_EOL.
											 '	'. $content0 . PHP_EOL .
											 '</div>' . PHP_EOL;
					$content = '<div class="animated '.$this -> ShorttextAnimateClass.'">'.PHP_EOL.
											 '	'. $content . PHP_EOL .
											 '</div>' . PHP_EOL;
				}
				If ($this -> BHideContent) {
					$tclass = 'textparent hc';
				} Else {
					$tclass = 'textparent';
				}

				$html.= '<div class="'.$tclass.'">'.PHP_EOL.
								'	<div class="'.$c0class.'">'.
										$content0.
								'	</div>		<!-- close class="'.$c0class.'"-->'.PHP_EOL;
				$html.= '	<div class="tsrcnt">'.PHP_EOL;
				$html.= '	'. $content . PHP_EOL;
 				$html.= '	</div>		<!-- close class="tsrcnt"-->'.PHP_EOL;
				$html.= '</div> 	<!-- Close class="'.$tclass.'" -->'.PHP_EOL;
			}break;
		}

		return $html;
	}
	private function Fcompile_single_column_content ($ShortText)
	{
		$html = '';
		// Compile teaser image tag
	  list($linktag, $imagetag, $closelinktag, $ImagePosition) = $this -> Fcompile_ImageLink();

/* ImagePosition -1: no image, just text
 * 							  0: ... left
 * 							  1: ... right
 * 							  2: ... alternating right and left half width of column width
 * 							  3: ... middle
 *                4: ... bottom
 */
		SWITCH ($ImagePosition) {
			case -1:	{// ... Text only, no image at all
				RegisterSearch($ShortText);
		      $html .=	'	<div class="shorttext">'.PHP_EOL.
										'		<span>'.PHP_EOL.
													$ShortText.PHP_EOL.
										'		</span>'.PHP_EOL;
					$html .=	'	</div> 	<!-- Close class="shorttext" -->'.PHP_EOL;

			} break;

			case 0:	{// ImagePosition left

				$imgpart = PHP_EOL.'	<div class="tlpic">'.
													 '		'.$linktag.$imagetag.$closelinktag;

				$imgpart .= '	</div> <!-- Close class="tlpic" -->'.PHP_EOL;

				// Now we add the teaser text on the right side
				RegisterSearch($ShortText);
				$html.=	'	<div class="shorttext">'.PHP_EOL.
								'	'.$imgpart.
								'		<span>'.PHP_EOL.
											$ShortText.PHP_EOL.
								'		</span>'.PHP_EOL;
/*
					If ($this -> newiconPosition == 1) {	// inside the teaser text
						$html .='		'.$this -> newiconHTML . PHP_EOL;
					}
*/
					$html .=	'	</div> 	<!-- Close class="shorttext" -->'.PHP_EOL;
			}break;

			case 1:	{// ImagePosition right

				$imgpart = PHP_EOL.'	<div class="trpic">'.
													 '		'.$linktag.$imagetag.$closelinktag;
/*
				If ($this -> newiconPosition == 2) {	// inside the picture
					$imgpart .=$this -> newiconHTML;
				}
*/
				$imgpart .= '	</div> <!-- Close class="trpic" -->'.PHP_EOL;

				// Now we add the teaser text on the right side
				RegisterSearch($ShortText);
				$html.=	'	<div class="shorttext">'.PHP_EOL.
								'	'.$imgpart.
								'		<span>'.PHP_EOL.
											$ShortText.PHP_EOL.
								'		</span>'.PHP_EOL;
/*
					If ($this -> newiconPosition == 1) {	// inside the teaser text
						$html .='		'.$this -> newiconHTML . PHP_EOL;
					}
*/
					$html .=	'	</div> 	<!-- Close class="shorttext" -->'.PHP_EOL;
			}break;

			case 2:	{	// ... alternating right and left; half width of column width
				if ($this -> ImagePosition_left) {/* Current image position shall be on the left side */
					/* Now we position the image to the left */
					{$html .= '								<div class="halfbox">';

						$imgpart = PHP_EOL.'	<div class="tlpic">'.
															 '		'.$linktag.$imagetag.$closelinktag;
/*
						If ($this -> newiconPosition == 2) {	// inside the picture
							$imgpart .=$this -> newiconHTML;
						}
*/
						$imgpart .= '	</div> <!-- Close class="tlpic" -->'.PHP_EOL;
						$html .= $imgpart.PHP_EOL;

					}$html .= '								</div> 	<!-- Close class="halfbox" -->';

					/*  ... and the text to the right... */
					{	$html .= '								<div class="halfbox">';
						RegisterSearch($ShortText);
						$html.=	'	<div class="shorttext">'.PHP_EOL.
										'		<span>'.PHP_EOL.
													$ShortText.PHP_EOL.
										'		</span>'.PHP_EOL;
/*
						If ($this -> newiconPosition == 1) {	// inside the teaser text
							$html .='		'.$this -> newiconHTML . PHP_EOL;
						}
*/
						$html .=	'	</div> 	<!-- Close class="shorttext" -->'.PHP_EOL;

					}	$html .= '								</div> 	<!-- Close class="halfbox" -->';

				} else {
					/* Now we position the text to the left... */
					{	$html .= '<div class="halfbox">';
						RegisterSearch($ShortText);
						$html.=	'	<div class="shorttext">'.PHP_EOL.
										'		<span>'.PHP_EOL.
													$ShortText.PHP_EOL.
										'		</span>'.PHP_EOL;
/*
						If ($this -> newiconPosition == 1) {	// inside the teaser text
							$html .='		'.$this -> newiconHTML . PHP_EOL;
						}
*/
						$html .=	'	</div> 	<!-- Close class="shorttext" -->'.PHP_EOL;
					}	$html .= '</div> 	<!-- Close class="halfbox" -->';

					/* ... and the image to the right */
					{	$html .= '<div class="halfbox">';
						$imgpart = PHP_EOL.'	<div class="trpic">'.
															 '		'.$linktag.$imagetag.$closelinktag;
/*
						If ($this -> newiconPosition == 2) {	// inside the picture
							$imgpart .=$this -> newiconHTML;
						}
*/
						$imgpart .= '	</div> <!-- Close class="trpic" -->'.PHP_EOL;
						$html .= $imgpart.PHP_EOL;
					}	$html .= '</div> 	<!-- Close class="halfbox" -->'.PHP_EOL;

				}
				$this -> ImagePosition_left = !$this -> ImagePosition_left;

			}break;

			case 3:	// ... middle
			case 4:	{// ... bottom
					RegisterSearch($ShortText);
					$html .= '<div class="shorttext">'.PHP_EOL.
										' <span>'.PHP_EOL.
										$ShortText.PHP_EOL.
										' </span>'.PHP_EOL;
/*
						If ($this -> newiconPosition == 1) {	// inside the teasure text
							$html .= $this -> newiconHTML;
						}
*/
						$html .= '</div>		<!-- close class="shorttext" -->'.PHP_EOL;
			}break;
		}
		return $html;
	}
	private function Fcompile_morelines ()
	{
		global $PLUGIN_PARAMETER;
		$html = PHP_EOL;
		If ($this -> BHideContent) {
			$mclass = 'tsrmore hc';
		} Else {
			$mclass = 'tsrmore';
		}
		if ($this -> BMoreLine) {
			If ($this -> BImageLink) {
				$href = make_link($this -> t);
				If ($href=='') $href='href="#"';
				If ($this -> BAnimateMore) {
					$html.= '									<a '.$href.' class="'.$mclass.'">' .PHP_EOL .
									'										<div class="animated '.$this -> MoreAnimateClass.'">'.PHP_EOL.
									'											'.$this -> moreline . PHP_EOL .
									'										</div>' . PHP_EOL .
									'									</a>'.PHP_EOL;

				} Else {
					$html.= '									<a '.$href.' class="'.$mclass.'">' .PHP_EOL .
									'										<div>'.PHP_EOL.
									'										'.$this -> moreline . PHP_EOL .
									'										</div>'.PHP_EOL.
									'									</a>'.PHP_EOL;
				}
			} else {
				$html.= '									<a ref="#" class="'.$mclass.'">' .PHP_EOL .
								'										<div>'.PHP_EOL.
								'											'.$this -> moreline . PHP_EOL .
								'										</div>' . PHP_EOL .
								'									</a>'.PHP_EOL;
			}
		}
/*
		If ($this -> newiconPosition == 3) {	// inside the "more..."-line
			If ($this -> newiconHTML != "") {
				$html .= $this -> newiconHTML;
			}
		}
*/
		return $html;
	}
	private function Fcompile_teaser_column()
	{
		// Add contents
		SWITCH ($this -> TeaserMode) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':{
				$html  = $this -> Fcompile_headlines ();
				$html .= $this -> Fcompile_teaser_contents();
				$html .= $this -> Fcompile_morelines();
			}break;

			case '6': {
				If ($this -> BHideContent) {
					$iclass = 'img6 hc '.$this -> ImgBorderClass;
				} Else {
					$iclass = 'img6 '.$this -> ImgBorderClass;
				}
				$html = '<div class="'.$iclass.'">'.PHP_EOL.
								'	'.$this -> Fcompile_largeimg (FALSE).PHP_EOL.
								'	<div class="hmode6">'.PHP_EOL.
								'		'.$this -> Fcompile_headlines ().PHP_EOL.
								'	</div>	<!-- Close class="hmode6" -->'.PHP_EOL.
								'</div>	<!-- Close class="'.$iclass.'" -->'.PHP_EOL;
			}break;

			case '7': {
				If ($this -> BHideContent) {
					$iclass = 'img7 hc '.$this -> ImgBorderClass;
				} Else {
					$iclass = 'img7 '.$this -> ImgBorderClass;
				}
				$html = '<div class="'.$iclass.'">'.PHP_EOL.
								'	'.$this -> Fcompile_largeimg (FALSE).PHP_EOL.
								'	<div class="hmode7">'.PHP_EOL.
								'		'.$this -> Fcompile_headlines ().PHP_EOL.
								'	</div>	<!-- Close class="hmode7" -->'.PHP_EOL.
								'</div>	<!-- Close class="img67" -->'.PHP_EOL;
			}break;

		}

		return $html;
	}
/* ==========================================================================
 * ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
 */

/******************************************************
 * render teaser in three column pieces
 ******************************************************/
	public function render_3col()
	{

		for ($i=0; $i < count($this -> TeaserContents); $i++) {

			$i1 = min((count($this -> TeaserContents)-1),$i+1);
			$i2 = min((count($this -> TeaserContents)-1),$i+2);

			$this -> t = $this -> TeaserContents[$i];

		  // Compile the "New icon" HTML-code
		  $this -> compile_newicon_html();

			If ($i % 3 == 0 ) {	/* starting a new group of three columns */
			// A column gets an author line if at least one column in the row has one
				$author0 =  trim($this -> TeaserContents[$i]['author']);
				$author1 = NULL;
				$author2 = NULL;
				If  ($i < count($this -> TeaserContents)-1)
					$author1 = trim($this -> TeaserContents[$i1]['author']);
				If  ($i < count($this -> TeaserContents)-2)
					$author2 = trim($this -> TeaserContents[$i2]['author']);
				If (!$this -> BAuthorLine
					||($author0==""
					&& $author1==""
					&& $author2=="")) {
						$this -> Bcompile_author = FALSE;
				} Else {
					$this -> Bcompile_author = TRUE;
					If ($author2!="") {
						If ($author1=="" && $i1 < count($this -> TeaserContents)) $this -> TeaserContents[$i1]['author']="&nbsp;";
						If ($author0=="") $this -> TeaserContents[$i  ]['author']="&nbsp;";
					} Else {
						If ($author1!="") {
							If ($author2=="" && $i+2 < count($this -> TeaserContents)) $this -> TeaserContents[$i+2]['author']="&nbsp;";
							If ($author0=="") $this -> TeaserContents[$i  ]['author']="&nbsp;";
						} Else {
							If ($author0!="") {
								If ($author2=="" && $i+2 < count($this -> TeaserContents)) $this -> TeaserContents[$i+2]['author']="&nbsp;";
								If ($author1=="" && $i+1 < count($this -> TeaserContents)) $this -> TeaserContents[$i+1]['author']="&nbsp;";
							}
						}
					}
				}
				// A column gets an addtext line if at least one column in the row has one

				$addtext0 =  trim($this -> TeaserContents[$i]['addtext']);
				$addtext1 = NULL;
				$addtext2 = NULL;
				If  ($i < count($this -> TeaserContents)-1)
					$addtext1 = trim($this -> TeaserContents[$i1]['addtext']);
				If  ($i < count($this -> TeaserContents)-2)
					$addtext2 = trim($this -> TeaserContents[$i2]['addtext']);

				If (!$this -> BAddTextLine
					||($addtext0==""
					&& $addtext1==""
					&& $addtext2=="")) {
						 $this -> Bcompile_addtext = FALSE;
				} Else {
					If  ($addtext2 != "") {
						If($addtext1=="" && $i+1 < count($this -> TeaserContents)) $this -> TeaserContents[$i+1]['addtext']="&nbsp;";
						If($addtext0=="") $this -> TeaserContents[$i  ]['addtext']="&nbsp;";
					} Else {
						If  ($addtext1!="") {
							If($addtext2=="" && $i+2 < count($this -> TeaserContents)) $this -> TeaserContents[$i+2]['addtext']="&nbsp;";
							If($addtext0=="") $this -> TeaserContents[$i  ]['addtext']="&nbsp;";
						} Else {
							If  ($addtext0!="") {
								If($addtext2=="" && $i+2 < count($this -> TeaserContents)) $this -> TeaserContents[$i+2]['addtext']="&nbsp;";
								If($addtext1=="" && $i+1 < count($this -> TeaserContents)) $this -> TeaserContents[$i+1]['addtext']="&nbsp;";
							}
						}
					}
					$this -> Bcompile_addtext = TRUE;
				}

				$caption0 =  trim($this -> TeaserContents[$i]['caption']);
				$caption1 = NULL;
				$caption2 = NULL;
				If  ($i1 < count($this -> TeaserContents))
					$caption1 = trim($this -> TeaserContents[$i1]['caption']);
				If  ($i2 < count($this -> TeaserContents))
					$caption2 = trim($this -> TeaserContents[$i2]['caption']);
				If (!$this -> BCaptionLine
					||($caption0==""
					&& $caption1==""
					&& $caption2=="")) {
						$this -> Bcompile_caption = FALSE;
				} Else {
					$this -> Bcompile_caption = TRUE;
					If ($caption2!="") {
						If ($caption1=="" && $i1 < count($this -> TeaserContents)) $this -> TeaserContents[$i1]['caption']="&nbsp;";
						If ($caption0=="") $this -> TeaserContents[$i  ]['caption']="&nbsp;";
					} Else {
						If ($caption1!="") {
							If ($caption2=="" && $i2 < count($this -> TeaserContents)) $this -> TeaserContents[$i2]['caption']="&nbsp;";
							If ($caption0=="") $this -> TeaserContents[$i  ]['caption']="&nbsp;";
						} Else {
							If ($caption0!="") {
								If ($caption2=="" && $i2 < count($this -> TeaserContents)) $this -> TeaserContents[$i2]['caption']="&nbsp;";
								If ($caption1=="" && $i1 < count($this -> TeaserContents)) $this -> TeaserContents[$i1]['caption']="&nbsp;";
							}
						}
					}
#					DEBUG($this -> TeaserContents[$i]['caption']);
#					DEBUG($this -> TeaserContents[$i1]['caption']);
#					DEBUG($this -> TeaserContents[$i2]['caption']);

				}

				/* Look for the longest piece of shorttext */
				$this -> t['maxShortText'] = trim($this -> TeaserContents[$i]['ShortText']);
				If (strlen(trim($this -> TeaserContents[$i1]['ShortText'])) > strlen($this -> t['maxShortText']))
					$this -> t['maxShortText'] = trim($this -> TeaserContents[$i1]['ShortText']);
				If (strlen(trim($this -> TeaserContents[$i2]['ShortText'])) > strlen($this -> t['maxShortText']))
					$this -> t['maxShortText'] = trim($this -> TeaserContents[$i2]['ShortText']);
				$this -> TeaserContents[$i ]['maxShortText'] = $this -> t['maxShortText'];
				$this -> TeaserContents[$i1]['maxShortText'] = $this -> t['maxShortText'];
				$this -> TeaserContents[$i2]['maxShortText'] = $this -> t['maxShortText'];
			}
			$this -> t['addtext'] = $this -> TeaserContents[$i]['addtext'];

			// Add contents into the correct row(=$y) and column (=$x)
			$x  = $i % 3;
			$y = (int)($i / 3.0);
			$fy  = $i / 3.0;
#			DEBUG('$'.'i = '.$i.' >>> $'.'x = '.$x.' --- $'.'fy = '.$fy.' --- $'.'y = '.$y);
			$this -> TeaserGriddy -> AddToXY($x, $y, $this -> Fcompile_teaser_column().$this -> newiconHTML);
		}
		$TsrPlaceHolder = array();
		$TsrPlaceHolder['Content']			= $this -> TeaserGriddy -> GetHtml();
		$TsrPlaceHolder['ActiveTeaser'] = $this -> ActiveTeaser;
		$TsrPlaceHolder['ColumnCount']	= $this -> ColumnCount;
		$pm = new PageMill();
		$pm->setVariableArray($TsrPlaceHolder);
		If (defined ('SENTRA_DESIGNER')) {
			$pm->setCondition("DesignerMode",true);
			$this -> TsrHTML = $pm->WriteFile('./templates/teaser.tpl');
		} else {
			$this -> TsrHTML = $pm->WriteFile(DESIGNTEMPLATES.'teaser.tpl');
		}
		unset($TsrPlaceHolder);
		unset($pm);

		return $this -> TsrHTML;
	}
/******************************************************
 * render teaser in two column pieces
 ******************************************************/
	public function render_2col()
	{
		foreach ($this -> TeaserContents as $i => $this -> t) {

			$i1 = min((count($this -> TeaserContents)-1),$i+1);


		  // Compile the "New icon" HTML-code
		  $this -> compile_newicon_html();

			If ($i % 2 == 0) {
			// A column gets a author line if at least one column in the row has one
				$author0 =  trim($this -> TeaserContents[$i]['author']);
				If  ($i1 < count($this -> TeaserContents)) {
					$author1 = trim($this -> TeaserContents[$i1]['author']);
				} Else {
					$author1 = NULL;
				}
				If (!$this -> BAuthorLine
					||($author0==""
					&& $author1=="")) {
						$this -> Bcompile_author = FALSE;
				} Else {
					If ($author1!="") {
						$this -> Bcompile_author = TRUE;
						If ($author0=="") $this -> TeaserContents[$i  ]['author']="&nbsp;";
					} Else {
						If ($author0!="") {
							$this -> Bcompile_author = TRUE;
							If ($author1=="" && $i1 <count($this -> TeaserContents)) $this -> TeaserContents[$i1]['author']="&nbsp;";
						}
					}

				}

			// A column gets a addtext line if at least one column in the row has one
				$addtext0 =  trim($this -> TeaserContents[$i]['addtext']);
				If  ($i1 < count($this -> TeaserContents)) {
					$addtext1 = trim($this -> TeaserContents[$i1]['addtext']);
				} Else {
					$addtext1 = NULL;
				}

				If (!$this -> BAddTextLine
					||($addtext0==""
					&& $addtext1=="")) {
						 $this -> Bcompile_addtext = FALSE;
				} Else {
					If  ($addtext1!="") {
						$this -> Bcompile_addtext = TRUE;
						If($addtext0=="") $this -> TeaserContents[$i  ]['addtext']="&nbsp;";
					} Else {
						If  ($addtext0!="") {
							$this -> Bcompile_addtext = TRUE;
							If($addtext1=="" && $i1 <count($this -> TeaserContents)) $this -> TeaserContents[$i1]['addtext']="&nbsp;";
						}
					}
				}

				$caption0 =  trim($this -> TeaserContents[$i]['caption']);
				If  ($i1 < count($this -> TeaserContents)) {
					$caption1 = trim($this -> TeaserContents[$i1]['caption']);
				} Else {
					$caption1 = NULL;
				}

				If (!$this -> BCaptionLine
					||($caption0==""
					&& $caption1=="")) {
						$this -> Bcompile_caption = FALSE;
				} Else {
					If ($caption1!="") {
						$this -> Bcompile_caption = TRUE;
						If ($caption0=="") $this -> TeaserContents[$i]['caption']="&nbsp;";
					} Else {
						If ($caption0!="") {
							$this -> Bcompile_caption = TRUE;
							If ($caption1=="" && $i1 < count($this -> TeaserContents)) $this -> TeaserContents[$i1]['caption']="&nbsp;";
						}
					}
				}
				$this -> t['maxShortText'] = trim($this -> TeaserContents[$i]['ShortText']);
				If (strlen(trim($this -> TeaserContents[$i1]['ShortText'])) > strlen($this -> t['maxShortText']))
					$this -> t['maxShortText'] = trim($this -> TeaserContents[$i1]['ShortText']);
				$this -> TeaserContents[$i ]['maxShortText'] = $this -> t['maxShortText'];
				$this -> TeaserContents[$i1]['maxShortText'] = $this -> t['maxShortText'];
			}
			$this -> t = $this -> TeaserContents[$i];

			$y = floor($i / 2);
			$y = (int)$y;
			$x = $i % 2;
			// Add contents
			$this -> TeaserGriddy -> AddToXY($x, $y, $this -> Fcompile_teaser_column().$this -> newiconHTML);
#			$this -> TeaserGriddy -> AddToXY($x, $y, $this -> Fcompile_teaser_column());

		}
		$TsrPlaceHolder = array();
		$TsrPlaceHolder['Content'] = $this -> TeaserGriddy -> GetHtml();
		$TsrPlaceHolder['ActiveTeaser'] = $this -> ActiveTeaser;
		$TsrPlaceHolder['ColumnCount'] = $this -> ColumnCount;
		$pm = new PageMill();
		$pm->setVariableArray($TsrPlaceHolder);
		If (defined ('SENTRA_DESIGNER')) {
			$pm->setCondition("DesignerMode",true);
			$this -> TsrHTML = $pm->WriteFile('./templates/teaser.tpl');
		} else {
			$this -> TsrHTML = $pm->WriteFile(DESIGNTEMPLATES.'teaser.tpl');
		}
		unset($TsrPlaceHolder);
		unset($pm);

		return $this -> TsrHTML;
	}
/******************************************************
 * render teaser in single column pieces
 ******************************************************/
	public function render_1col()
	{
		$this -> Bcompile_addtext = TRUE;
		foreach ($this -> TeaserContents as $i => $this -> t) {

		  // Compile the "New icon" HTML-code
		  $this -> compile_newicon_html();

			$this -> TeaserContents[$i ]['maxShortText'] = $this -> TeaserContents[$i ]['ShortText'];
			$this -> t = $this -> TeaserContents[$i];
#			$this -> TeaserGriddy -> AddToXY(0, $i, $this -> Fcompile_teaser_column());
			$this -> TeaserGriddy -> AddToXY(0, $i, $this -> Fcompile_teaser_column().$this -> newiconHTML);
		}

		$TsrPlaceHolder = array();
		$TsrPlaceHolder['Content'] = $this -> TeaserGriddy -> GetHtml();
		$TsrPlaceHolder['ActiveTeaser'] = $this -> ActiveTeaser;
		$TsrPlaceHolder['ColumnCount'] = $this -> ColumnCount;
		$pm = new PageMill();
		$pm->setVariableArray($TsrPlaceHolder);
		If (defined ('SENTRA_DESIGNER')) {
			$pm->setCondition("DesignerMode",true);
			$this -> TsrHTML = $pm->WriteFile('./templates/teaser.tpl');
		} else {
			$this -> TsrHTML = $pm->WriteFile(DESIGNTEMPLATES.'teaser.tpl');
		}
		unset($TsrPlaceHolder);
		unset($pm);

		return $this -> TsrHTML;
	}
	public function Render_Teaser()
	{
		SWITCH ($this -> ColumnCount){
			case 1:
				return $this -> render_1col();
			break;

			case 2:
				return $this -> render_2col();
			break;

			case 3:
				return $this -> render_3col();
			break;
		}
	}
}
?>